/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.spi.time;

import com.chutneytesting.task.spi.time.DurationParser;
import com.chutneytesting.task.spi.time.DurationUnit;
import com.chutneytesting.task.spi.time.DurationWithUnitParser;
import com.chutneytesting.task.spi.time.UntilHourDurationParser;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class Duration {
    private static final DecimalFormat DISPLAY_FORMATTER = new DecimalFormat("#.##");
    private static final DurationParser[] PARSERS = new DurationParser[]{new DurationWithUnitParser(), new UntilHourDurationParser()};
    private static final String ERROR_MESSAGE_TEMPLATE = "Cannot parse duration: %1$s\nAvailable patterns are:\n" + Duration.buildErrorMessageTemplate();
    private final double durationValue;
    private final DurationUnit durationUnit;

    Duration(double durationValue, DurationUnit durationUnit) {
        this.durationValue = durationValue;
        this.durationUnit = durationUnit;
    }

    private static String buildErrorMessageTemplate() {
        return Arrays.stream(PARSERS).map(DurationParser::description).map(d -> "- " + d).collect(Collectors.joining("\n"));
    }

    public long toMilliseconds() {
        return Math.round(this.durationUnit.toMilliFactor * this.durationValue);
    }

    public static Duration parse(String literalDuration) {
        Optional<Duration> parsed = Arrays.stream(PARSERS).map(parser -> parser.parse(literalDuration)).filter(Optional::isPresent).map(Optional::get).findFirst();
        return parsed.orElseThrow(() -> new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, literalDuration)));
    }

    public String toString() {
        return DISPLAY_FORMATTER.format(this.durationValue).replace(',', '.') + " " + (Object)((Object)this.durationUnit);
    }

    public double getDurationValue() {
        return this.durationValue;
    }

    public DurationUnit getDurationUnit() {
        return this.durationUnit;
    }
}

