/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.spi.injectable;

import com.chutneytesting.task.spi.injectable.SecurityInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public interface Target {
    public TargetId id();

    public String url();

    public Map<String, String> properties();

    public SecurityInfo security();

    default public String name() {
        return this.id().name();
    }

    default public URI getUrlAsURI() {
        try {
            return new URI(this.url());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface TargetId {
        public String name();
    }
}

