/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql.core;

import com.chutneytesting.task.sql.core.Column;
import com.chutneytesting.task.sql.core.Row;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Records {
    public final int affectedRows;
    public final List<String> headers;
    @Deprecated
    public final List<List<Object>> rows;
    public final List<Column> columns;
    public final List<Row> records;

    public Records(int affectedRows, List<Column> columns, List<Row> records) {
        this.affectedRows = affectedRows;
        this.columns = columns;
        this.records = records;
        this.headers = this.columns.stream().map(Column::name).collect(Collectors.toList());
        this.rows = this.records.stream().map(r -> r.cells).map(l -> l.stream().map(c -> c.value).collect(Collectors.toList())).collect(Collectors.toList());
    }

    List<String> getHeaders() {
        return this.headers;
    }

    List<List<Object>> getRows() {
        return this.rows;
    }

    public int count() {
        return this.records.size();
    }

    public Object[][] toMatrix() {
        Object[][] matrix = new Object[this.records.size()][this.columns.size()];
        for (int rowIndex = 0; rowIndex < this.records.size(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.columns.size(); ++columnIndex) {
                matrix[rowIndex][columnIndex] = this.records.get((int)rowIndex).get((int)columnIndex).value;
            }
        }
        return matrix;
    }

    @Deprecated
    public List<Map<String, Object>> toListOfMaps() {
        return this.toListOfMaps(this.records.size());
    }

    @Deprecated
    public List<Map<String, Object>> toListOfMaps(int n) {
        int limit = Math.min(n, this.records.size());
        ArrayList<Map<String, Object>> listOfMaps = new ArrayList<Map<String, Object>>(limit);
        for (Row row : this.records.subList(0, limit)) {
            LinkedHashMap<String, Object> aRow = new LinkedHashMap<String, Object>(this.columns.size());
            for (Column column : this.columns) {
                aRow.put(column.name, row.get((Column)column).value);
            }
            listOfMaps.add(aRow);
        }
        return listOfMaps;
    }

    public Map<String, Object> asMap(int index) {
        return this.toListOfMaps().get(index);
    }

    public String printable(int limit) {
        StringBuilder sb = new StringBuilder();
        Map<Column, Integer> maxColumnLength = this.maximumColumnLength(limit);
        sb.append(this.tableHeaders(maxColumnLength));
        sb.append(this.tableRows(limit, maxColumnLength));
        return sb.toString();
    }

    Map<Column, Integer> maximumColumnLength(int limit) {
        return this.columns.stream().collect(Collectors.toMap(c -> c, c -> this.maximumLength((Column)c, limit)));
    }

    private int maximumLength(Column column, int limit) {
        return Math.max(column.name.length(), this.records.stream().limit(limit).map(r -> r.get((Column)column).value.toString().length()).max(Integer::compare).orElse(0));
    }

    public String tableHeaders(Map<Column, Integer> maxColumnLength) {
        StringBuilder sb = new StringBuilder();
        if (this.columns.size() > 0) {
            sb.append("|");
            this.columns.forEach(column -> sb.append(" ").append(column.printHeader((Integer)maxColumnLength.get(column))).append(" |"));
            sb.append("\n");
            sb.append("-".repeat(sb.length() - 1));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String nWhitespaces(int i) {
        return " ".repeat(i);
    }

    public String tableRows(int limit, Map<Column, Integer> maximumColumnLength) {
        List<String> lines = this.records.stream().limit(limit).map(r -> r.print(maximumColumnLength)).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        lines.forEach(sb::append);
        return sb.toString();
    }

    public String rowAsString(Map<String, Object> row, Map<String, Integer> maxColumnLength) {
        StringBuilder sb = new StringBuilder();
        if (!row.isEmpty()) {
            sb.append("|");
            row.forEach((k, v) -> sb.append(" ").append(v.toString()).append(this.nWhitespaces((Integer)maxColumnLength.get(k) - v.toString().length())).append(" |"));
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return "Records{affectedRows=" + this.affectedRows + ", headers=" + this.headers + ", records=" + this.records + "}";
    }
}

