/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.injectable.TasksConfiguration;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.chutneytesting.task.sql.core.DefaultSqlClientFactory;
import com.chutneytesting.task.sql.core.Records;
import com.chutneytesting.task.sql.core.SqlClient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class SqlTask
implements Task {
    public static final String CONFIGURABLE_NB_LOGGED_ROW = "chutney.tasks.sql.nbLoggedRow";
    private static final Integer DEFAULT_NB_LOGGED_ROW = 30;
    private final Target target;
    private final Logger logger;
    private final List<String> statements;
    private final Integer nbLoggedRow;
    private final DefaultSqlClientFactory clientFactory = new DefaultSqlClientFactory();

    public SqlTask(Target target, Logger logger, TasksConfiguration configuration, @Input(value="statements") List<String> statements, @Input(value="nbLoggedRow") Integer nbLoggedRow) {
        this.target = target;
        this.logger = logger;
        this.statements = statements;
        this.nbLoggedRow = Optional.ofNullable(nbLoggedRow).orElse(configuration.getInteger(CONFIGURABLE_NB_LOGGED_ROW, DEFAULT_NB_LOGGED_ROW));
    }

    public List<String> validateInputs() {
        Validator targetPropertiesValidation = Validator.of((Object)this.target).validate(t -> this.target.property("jdbcUrl").orElse(""), StringUtils::isNotBlank, "Missing Target property 'jdbcUrl'");
        return Validator.getErrorsFrom((Validator[])new Validator[]{targetPropertiesValidation, TaskValidatorsUtils.targetValidation((Target)this.target), TaskValidatorsUtils.notEmptyListValidation(this.statements, (String)"statements")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutionResult execute() {
        SqlClient sqlClient = this.clientFactory.create(this.target);
        try {
            ArrayList records = new ArrayList();
            HashMap outputs = new HashMap();
            AtomicBoolean failure = new AtomicBoolean(false);
            this.statements.forEach(statement -> {
                try {
                    Records result = sqlClient.execute((String)statement);
                    records.add(result);
                    this.logger.info(result.printable(this.nbLoggedRow));
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage() + " for " + statement + "; Vendor error code: " + e.getErrorCode());
                    records.add(sqlClient.emptyRecords());
                    failure.set(true);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    records.add(sqlClient.emptyRecords());
                    failure.set(true);
                }
            });
            outputs.put("recordResult", records);
            TaskExecutionResult taskExecutionResult = failure.get() ? TaskExecutionResult.ko(outputs) : TaskExecutionResult.ok(outputs);
            return taskExecutionResult;
        }
        finally {
            if (sqlClient != null) {
                sqlClient.closeDatasource();
            }
        }
    }
}

