/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import org.apache.commons.lang3.StringUtils;

public class DefaultMongoDatabaseFactory
implements MongoDatabaseFactory {
    @Override
    public CloseableResource<MongoDatabase> create(Target target) throws IllegalArgumentException {
        String databaseName = target.property("databaseName").orElse("");
        if (StringUtils.isEmpty((CharSequence)databaseName)) {
            throw new IllegalArgumentException("Missing Target property 'databaseName'");
        }
        String connectionString = String.format("mongodb://%s:%d/", target.host(), target.port());
        MongoClientSettings.Builder mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString));
        if (target.user().isPresent()) {
            String user = (String)target.user().get();
            String password = target.userPassword().orElse("");
            mongoClientSettings.credential(MongoCredential.createCredential((String)user, (String)databaseName, (char[])password.toCharArray()));
        }
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings.build());
        return CloseableResource.build((Object)mongoClient.getDatabase(databaseName), () -> ((MongoClient)mongoClient).close());
    }
}

