/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms.consumer.bodySelector;

import com.chutneytesting.task.jms.consumer.bodySelector.BodySelector;
import com.chutneytesting.task.jms.consumer.bodySelector.BodySelectorParser;
import com.chutneytesting.task.jms.consumer.bodySelector.XpathBodySelectorParser;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class BodySelectorFactory {
    private static final BodySelectorParser[] FACTORIES = new BodySelectorParser[]{new XpathBodySelectorParser()};

    public BodySelector build(String selector) throws IllegalArgumentException {
        return Arrays.stream(FACTORIES).map(factory -> factory.tryParse(selector)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalArgumentException("Wrong bodySelector syntax. " + this.syntaxDescription()));
    }

    public String syntaxDescription() {
        return "Available syntaxes are:\n\t- " + Arrays.stream(FACTORIES).map(BodySelectorParser::description).collect(Collectors.joining("\n\t- "));
    }
}

