/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.common.JsonUtils;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.ReadContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

public class JsonCompareTask
implements Task {
    private final Logger logger;
    private final String document1;
    private final String document2;
    private final Map<String, String> paths;
    private final String mode;
    private static final Map<String, String> DEFAULT_PATHS = Map.of("$", "$");

    public JsonCompareTask(Logger logger, @Input(value="document1") String document1, @Input(value="document2") String document2, @Input(value="comparingPaths") Map<String, String> comparingPaths, @Input(value="mode") String mode) {
        this.logger = logger;
        this.document1 = document1;
        this.document2 = document2;
        this.paths = Optional.ofNullable(comparingPaths).filter(Predicate.not(Map::isEmpty)).orElse(DEFAULT_PATHS);
        this.mode = Optional.ofNullable(mode).filter(Predicate.not(String::isEmpty)).map(String::toUpperCase).orElse(COMPARE_MODE.STRICT.name());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.document1, (String)"document1"), TaskValidatorsUtils.notBlankStringValidation((String)this.document2, (String)"document2"), TaskValidatorsUtils.enumValidation(COMPARE_MODE.class, (String)this.mode, (String)"mode")});
    }

    public TaskExecutionResult execute() {
        DocumentContext doc1 = JsonPath.parse((String)JsonUtils.jsonStringify(this.document1));
        DocumentContext doc2 = JsonPath.parse((String)JsonUtils.jsonStringify(this.document2));
        AtomicBoolean result = new AtomicBoolean(true);
        this.paths.forEach((arg_0, arg_1) -> this.lambda$execute$0((ReadContext)doc1, (ReadContext)doc2, result, arg_0, arg_1));
        if (!result.get()) {
            return TaskExecutionResult.ko();
        }
        return TaskExecutionResult.ok();
    }

    private boolean isEqual(Object read1, Object read2) {
        switch (COMPARE_MODE.valueOf(this.mode)) {
            case STRICT: {
                return read1.equals(read2);
            }
            case LENIENT: {
                return JsonUtils.lenientEqual(read1, read2, null);
            }
        }
        return false;
    }

    private /* synthetic */ void lambda$execute$0(ReadContext doc1, ReadContext doc2, AtomicBoolean result, String path1, String path2) {
        try {
            Object read1 = doc1.read(path1, new com.jayway.jsonpath.Predicate[0]);
            Object read2 = doc2.read(path2, new com.jayway.jsonpath.Predicate[0]);
            if (!this.isEqual(read1, read2)) {
                result.set(false);
                this.logger.error("Value [" + read1 + "] at path [" + path1 + "] is not equal to value [" + read2 + "] at path [" + path2 + "]");
            } else {
                this.logger.info(read1.toString());
                this.logger.info(read2.toString());
            }
        }
        catch (JsonPathException ex) {
            this.logger.error(ex.getMessage());
        }
    }

    public static enum COMPARE_MODE {
        STRICT,
        LENIENT;

    }
}

