/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.time.Duration;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.chutneytesting.task.ssh.SshClientFactory;
import com.chutneytesting.task.ssh.sftp.ChutneySftpClient;
import com.chutneytesting.task.ssh.sftp.SftpClientImpl;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SftpFileInfoTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final String file;
    private final String timeout;

    public SftpFileInfoTask(Target target, Logger logger, @Input(value="file") String file, @Input(value="timeout") String timeout) {
        this.target = target;
        this.logger = logger;
        this.file = file;
        this.timeout = (String)StringUtils.defaultIfEmpty((CharSequence)timeout, (CharSequence)SshClientFactory.DEFAULT_TIMEOUT);
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.file, (String)"file"), TaskValidatorsUtils.durationValidation((String)this.timeout, (String)"timeout"), TaskValidatorsUtils.targetValidation((Target)this.target)});
    }

    public TaskExecutionResult execute() {
        TaskExecutionResult taskExecutionResult;
        block8: {
            ChutneySftpClient client = SftpClientImpl.buildFor(this.target, Duration.parseToMs((String)this.timeout), this.logger);
            try {
                Map<String, Object> info = client.getAttributes(this.file);
                taskExecutionResult = TaskExecutionResult.ok(info);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    return TaskExecutionResult.ko();
                }
            }
            client.close();
        }
        return taskExecutionResult;
    }
}

