/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql.core;

import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.sql.core.SqlClient;
import com.chutneytesting.task.sql.core.SqlClientFactory;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Properties;

public class DefaultSqlClientFactory
implements SqlClientFactory {
    private final int DEFAULT_MAX_FETCH_SIZE = 1000;

    @Override
    public SqlClient create(Target target) {
        return this.doCreate(target);
    }

    private SqlClient doCreate(Target target) {
        Properties props = new Properties();
        props.put("jdbcUrl", target.property("jdbcUrl").orElse(target.uri().toString()));
        target.user().ifPresent(user -> props.put("username", user));
        target.userPassword().ifPresent(password -> props.put("password", password));
        props.putAll((Map<?, ?>)target.prefixedProperties("dataSource."));
        HikariConfig config = new HikariConfig(props);
        HikariDataSource ds = new HikariDataSource(config);
        return new SqlClient(ds, target.numericProperty("maxFetchSize").map(Number::intValue).orElse(1000));
    }
}

