/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoTaskValidatorsUtils;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MongoListTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;

    public MongoListTask(Target target, Logger logger) {
        this.target = target;
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{MongoTaskValidatorsUtils.mongoTargetValidation(this.target)});
    }

    public TaskExecutionResult execute() {
        TaskExecutionResult taskExecutionResult;
        block8: {
            CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);
            try {
                MongoIterable collectionNames = ((MongoDatabase)database.getResource()).listCollectionNames();
                ArrayList collectionNameList = new ArrayList();
                collectionNames.iterator().forEachRemaining(collectionNameList::add);
                this.logger.info("Found " + collectionNameList.size() + " collection(s)");
                taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("collectionNames", collectionNameList));
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(e.getMessage());
                    return TaskExecutionResult.ko();
                }
            }
            database.close();
        }
        return taskExecutionResult;
    }
}

