/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.Validator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MicrometerTimerTask
implements Task {
    protected static final String OUTPUT_TIMER = "micrometerTimer";
    private final Logger logger;
    private final String name;
    private final String description;
    private final List<String> tags;
    private final String bufferLength;
    private final String expiry;
    private final String maxValue;
    private final String minValue;
    private final String percentilePrecision;
    private final Boolean publishPercentilesHistogram;
    private final String percentiles;
    private final String sla;
    private Timer timer;
    private final MeterRegistry registry;
    private final String timeunit;
    private final String record;

    public MicrometerTimerTask(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="tags") List<String> tags, @Input(value="bufferLength") String bufferLength, @Input(value="expiry") String expiry, @Input(value="maxValue") String maxValue, @Input(value="minValue") String minValue, @Input(value="percentilePrecision") String percentilePrecision, @Input(value="publishPercentilesHistogram") Boolean publishPercentilesHistogram, @Input(value="percentiles") String percentiles, @Input(value="sla") String sla, @Input(value="timer") Timer timer, @Input(value="registry") MeterRegistry registry, @Input(value="timeunit") String timeunit, @Input(value="record") String record) {
        this.logger = logger;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.bufferLength = bufferLength;
        this.expiry = expiry;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.percentilePrecision = percentilePrecision;
        this.publishPercentilesHistogram = publishPercentilesHistogram;
        this.percentiles = percentiles;
        this.sla = sla;
        this.timeunit = Optional.ofNullable(timeunit).orElse(TimeUnit.SECONDS.name());
        this.record = record;
        this.timer = timer;
        this.registry = Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
    }

    public List<String> validateInputs() {
        Validator metricNameValidation = Validator.of(null).validate(a -> this.name != null || this.timer != null, "name and timer cannot be both null");
        return Validator.getErrorsFrom((Validator[])new Validator[]{metricNameValidation, MicrometerTaskHelper.integerStringValidation(this.bufferLength, "bufferLength"), MicrometerTaskHelper.integerStringValidation(this.percentilePrecision, "percentilePrecision"), MicrometerTaskHelper.durationStringValidation(this.maxValue, "maxValue"), MicrometerTaskHelper.durationStringValidation(this.minValue, "minValue"), MicrometerTaskHelper.durationStringValidation(this.record, "record"), MicrometerTaskHelper.durationStringValidation(this.expiry, "expiry"), MicrometerTaskHelper.percentilesListValidation(this.percentiles), MicrometerTaskHelper.slaListToDoublesValidation(this.sla)});
    }

    public TaskExecutionResult execute() {
        try {
            this.timer = Optional.ofNullable(this.timer).orElseGet(() -> this.retrieveTimer(this.registry));
            if (this.record != null) {
                this.timer.record(MicrometerTaskHelper.parseDuration(this.record));
                this.logger.info("Timer updated by " + this.record);
            }
            MicrometerTaskHelper.logTimerState(this.logger, this.timer, TimeUnit.valueOf(this.timeunit));
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_TIMER, this.timer));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private Timer retrieveTimer(MeterRegistry registry) {
        Timer.Builder builder = Timer.builder((String)Objects.requireNonNull(this.name)).description(this.description).distributionStatisticBufferLength(MicrometerTaskHelper.parseIntOrNull(this.bufferLength)).distributionStatisticExpiry(MicrometerTaskHelper.parseDurationOrNull(this.expiry)).maximumExpectedValue(MicrometerTaskHelper.parseDurationOrNull(this.maxValue)).minimumExpectedValue(MicrometerTaskHelper.parseDurationOrNull(this.minValue)).percentilePrecision(MicrometerTaskHelper.parseIntOrNull(this.percentilePrecision)).publishPercentileHistogram(this.publishPercentilesHistogram).publishPercentiles(MicrometerTaskHelper.parseMapOrNull(this.percentiles, MicrometerTaskHelper::parsePercentilesList)).serviceLevelObjectives(MicrometerTaskHelper.parseMapOrNull(this.sla, MicrometerTaskHelper::parseSlaListToDurations));
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registry);
    }
}

