/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.http;

import com.chutneytesting.task.http.HttpTaskHelper;
import com.chutneytesting.task.http.domain.HttpClient;
import com.chutneytesting.task.http.domain.HttpClientFactory;
import com.chutneytesting.task.http.domain.HttpTask;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.time.Duration;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class HttpPatchTask
implements Task {
    private static final String DEFAULT_TIMEOUT = "2000 ms";
    private final Target target;
    private final Logger logger;
    private final String uri;
    private final Map<String, String> headers;
    private final Object body;
    private final String timeout;

    public HttpPatchTask(Target target, Logger logger, @Input(value="uri") String uri, @Input(value="body") String body, @Input(value="headers") Map<String, String> headers, @Input(value="timeout") String timeout) {
        this.target = target;
        this.logger = logger;
        this.uri = uri;
        this.body = body;
        this.headers = headers != null ? headers : new HashMap();
        this.timeout = Optional.ofNullable(timeout).orElse(DEFAULT_TIMEOUT);
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom(HttpTaskHelper.httpCommonValidation(this.target, this.timeout));
    }

    public TaskExecutionResult execute() {
        HttpClient httpClient = new HttpClientFactory().create(this.target, String.class, (int)Duration.parseToMs((String)this.timeout));
        HttpHeaders httpHeaders = new HttpHeaders();
        this.headers.forEach((key, value) -> httpHeaders.add(key, value));
        Supplier<ResponseEntity<String>> caller = () -> httpClient.patch(this.uri, this.body, (MultiValueMap<String, String>)httpHeaders);
        return HttpTask.httpCall(this.logger, caller);
    }
}

