/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.common.ResourceResolver;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.SAXException;

public class XsdValidationTask
implements Task {
    private String xml;
    private String xsdPath;
    private Logger logger;
    private ResourceLoader resourceLoader = new DefaultResourceLoader(XsdValidationTask.class.getClassLoader());

    public XsdValidationTask(Logger logger, @Input(value="xml") String xml, @Input(value="xsd") String xsdPath) {
        this.logger = logger;
        this.xml = xml;
        this.xsdPath = xsdPath;
    }

    public List<String> validateInputs() {
        Validator xmlValidation = Validator.of((Object)this.xsdPath).validate(Objects::nonNull, "No xsd provided").validate(x -> this.resourceLoader.getResource(x), resource -> resource.exists(), "Cannot find xsd");
        return Validator.getErrorsFrom((Validator[])new Validator[]{xmlValidation, TaskValidatorsUtils.notBlankStringValidation((String)this.xml, (String)"xml")});
    }

    public TaskExecutionResult execute() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(new ResourceResolver(this.xsdPath));
            Resource resource = this.resourceLoader.getResource(this.xsdPath);
            StreamSource schemaSource = new StreamSource(resource.getInputStream());
            Schema schema = factory.newSchema(schemaSource);
            javax.xml.validation.Validator validator = schema.newValidator();
            try (StringReader sr = new StringReader(this.xml);){
                StreamSource ss = new StreamSource(sr);
                validator.validate(ss);
            }
        }
        catch (IOException | UncheckedIOException | SAXException e) {
            this.logger.error("Exception: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
        return TaskExecutionResult.ok();
    }
}

