/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp.consumer;

import com.chutneytesting.task.spi.injectable.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;

public class ConsumerSupervisor {
    private static final int LOCK_WAITING = 500;
    private static ConsumerSupervisor instance;
    private final Set<String> queuesLocked = new HashSet<String>();

    private ConsumerSupervisor() {
    }

    public static synchronized ConsumerSupervisor getInstance() {
        if (instance == null) {
            instance = new ConsumerSupervisor();
        }
        return instance;
    }

    public boolean isLocked(String queueName) {
        return this.queuesLocked.contains(queueName);
    }

    public synchronized boolean lock(String queueName) {
        return this.queuesLocked.add(queueName);
    }

    public synchronized void unlock(String queueName) {
        this.queuesLocked.remove(queueName);
    }

    public Pair<Boolean, Long> waitUntilQueueAvailable(String queueName, long originalDuration, Logger logger) throws InterruptedException {
        long timeLeft;
        boolean locked = this.lock(queueName);
        for (timeLeft = originalDuration; !locked && timeLeft >= 500L; timeLeft -= 500L) {
            TimeUnit.MILLISECONDS.sleep(500L);
            locked = this.lock(queueName);
        }
        if (!locked) {
            logger.error("Cannot consume on queue [" + queueName + "]. Another consumer already listening on this queue");
            return Pair.of((Object)false, (Object)0L);
        }
        if (originalDuration - timeLeft > 0L) {
            logger.info("Waited " + (originalDuration - timeLeft) + " ms to acquire lock to consume queue " + queueName);
        }
        return Pair.of((Object)true, (Object)timeLeft);
    }
}

