/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh.sftp;

import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.ssh.SshClientFactory;
import com.chutneytesting.task.ssh.sftp.ChutneySftpClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.impl.DefaultSftpClientFactory;

public class SftpClientImpl
implements ChutneySftpClient {
    private final ClientSession session;
    private final SftpClient sftpClient;

    private SftpClientImpl(ClientSession session, SftpClient sftpClient) {
        this.session = session;
        this.sftpClient = sftpClient;
    }

    @Override
    public void upload(String source, String destination) throws IOException {
        Path file = Paths.get(source, new String[0]);
        byte[] fileContent = Files.readAllBytes(file);
        try (BufferedOutputStream out = new BufferedOutputStream(this.sftpClient.write(destination));){
            out.write(fileContent);
        }
    }

    @Override
    public void download(String source, String destination) throws IOException {
        try (InputStream read = this.sftpClient.read(source);){
            byte[] fileContent = read.readAllBytes();
            File file = new File(destination);
            file.getParentFile().mkdirs();
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                out.write(fileContent);
            }
        }
    }

    @Override
    public List<String> listDirectory(String directory) throws IOException {
        SftpClient.CloseableHandle handle = this.sftpClient.openDir(directory);
        Iterable files = this.sftpClient.listDir((SftpClient.Handle)handle);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(files.iterator(), 16), false).map(SftpClient.DirEntry::getFilename).filter(f -> !".".equals(f) && !"..".equals(f)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getAttributes(String file) throws IOException {
        SftpClient.Attributes stat = this.sftpClient.stat(file);
        return Map.of("CreationDate", LocalDateTime.ofInstant(stat.getCreateTime().toInstant(), ZoneId.systemDefault()), "lastAccess", LocalDateTime.ofInstant(stat.getAccessTime().toInstant(), ZoneId.systemDefault()), "lastModification", LocalDateTime.ofInstant(stat.getModifyTime().toInstant(), ZoneId.systemDefault()), "type", FileType.from((SftpClient.Attributes)stat).label, "owner:group", stat.getOwner() + ":" + stat.getGroup());
    }

    @Override
    public void close() throws Exception {
        this.sftpClient.close();
        this.session.close();
    }

    public static ChutneySftpClient buildFor(Target target, long timeout, Logger logger) throws IOException {
        ClientSession session = SshClientFactory.buildSSHClientSession(target, timeout);
        return new SftpClientImpl(session, SftpClientImpl.buildSftpClient(session, logger));
    }

    private static SftpClient buildSftpClient(ClientSession session, Logger logger) throws IOException {
        DefaultSftpClientFactory factory = DefaultSftpClientFactory.INSTANCE;
        SftpClient client = factory.createSftpClient(session, (SftpErrorDataHandler)new TaskSftpErrorDataHandler(logger));
        return client.singleSessionInstance();
    }

    private static enum FileType {
        FILE("regular file"),
        DIRECTORY("directory"),
        SYMBOLIC_LINK("symbolic link"),
        OTHER("other");

        public final String label;

        private FileType(String label) {
            this.label = label;
        }

        static FileType from(SftpClient.Attributes stat) {
            if (stat.isRegularFile()) {
                return FILE;
            }
            if (stat.isDirectory()) {
                return DIRECTORY;
            }
            if (stat.isSymbolicLink()) {
                return SYMBOLIC_LINK;
            }
            return OTHER;
        }
    }

    private static class TaskSftpErrorDataHandler
    implements SftpErrorDataHandler {
        private final Logger logger;

        public TaskSftpErrorDataHandler(Logger logger) {
            this.logger = logger;
        }

        public void errorData(byte[] buf, int start, int len) {
            this.logger.error(new String(buf, StandardCharsets.UTF_8));
        }
    }
}

