/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql.core;

import com.chutneytesting.task.sql.core.Cell;
import com.chutneytesting.task.sql.core.Column;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Row {
    final List<Cell> cells;

    public Row(List<Cell> values) {
        this.cells = values;
    }

    public Cell get(Column column) {
        return this.cells.stream().filter(v -> v.column.equals(column)).findFirst().orElse(Cell.NONE);
    }

    public Cell get(String header) {
        return this.cells.stream().filter(v -> v.column.name.equals(header)).findFirst().orElse(Cell.NONE);
    }

    public Cell get(int index) {
        return this.cells.stream().filter(v -> v.column.index == index).findFirst().orElse(Cell.NONE);
    }

    public String print(Map<Column, Integer> maxLength) {
        StringBuilder sb = new StringBuilder();
        if (!this.cells.isEmpty()) {
            sb.append("|");
            this.cells.forEach(c -> sb.append(" ").append(c.print((Integer)maxLength.get(c.column))).append(" |"));
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row row = (Row)o;
        return this.cells.equals(row.cells);
    }

    public int hashCode() {
        return Objects.hash(this.cells);
    }

    public String toString() {
        return "Row{cells=" + this.cells + "}";
    }
}

