/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.radius;

import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.List;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusClient;

public final class RadiusHelper {
    static final String SHARED_SECRET_TARGET_PROPERTY = "sharedSecret";
    static final String AUTH_PORT_TARGET_PROPERTY = "authenticatePort";
    static final String ACC_PORT_TARGET_PROPERTY = "accountingPort";

    private RadiusHelper() {
    }

    public static String getRadiusProtocol(String protocol) {
        return "chap".equalsIgnoreCase(protocol) ? "chap" : "pap";
    }

    public static Validator<Target> radiusTargetPropertiesValidation(Target target) {
        return TaskValidatorsUtils.targetPropertiesNotBlankValidation((Target)target, (String[])new String[]{SHARED_SECRET_TARGET_PROPERTY, AUTH_PORT_TARGET_PROPERTY, ACC_PORT_TARGET_PROPERTY});
    }

    public static Validator<Target> radiusTargetPortPropertiesValidation(Target target) {
        Validator validator = Validator.of((Object)target);
        for (String property : List.of(AUTH_PORT_TARGET_PROPERTY, ACC_PORT_TARGET_PROPERTY)) {
            validator.validate(t -> Integer.parseInt((String)t.properties().get(property)), port -> port > 0, property + " is not a valid port number");
        }
        return validator;
    }

    public static RadiusClient createRadiusClient(Target target) {
        String hostname = target.host();
        String sharedSecret = (String)target.properties().get(SHARED_SECRET_TARGET_PROPERTY);
        int authenticatePort = Integer.parseInt((String)target.properties().get(AUTH_PORT_TARGET_PROPERTY));
        int accountingPort = Integer.parseInt((String)target.properties().get(ACC_PORT_TARGET_PROPERTY));
        RadiusClient client = new RadiusClient(hostname, sharedSecret);
        client.setAuthPort(authenticatePort);
        client.setAcctPort(accountingPort);
        return client;
    }

    public static String silentGetAttribute(RadiusPacket response, String attribute) {
        try {
            RadiusAttribute replyMessage = response.getAttribute(attribute);
            return replyMessage != null ? replyMessage.getAttributeValue() : "";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }
}

