/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms;

import com.chutneytesting.task.jms.JmsConnectionFactory;
import com.chutneytesting.task.jms.UncheckedJmsException;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;

public class JmsSenderTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final String destination;
    private final String body;
    private final Map<String, String> headers;
    private final JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory();

    public JmsSenderTask(Target target, Logger logger, @Input(value="destination") String destination, @Input(value="body") String body, @Input(value="headers") Map<String, String> headers) {
        this.target = target;
        this.logger = logger;
        this.destination = destination;
        this.body = body;
        this.headers = headers != null ? headers : Collections.emptyMap();
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.targetValidation((Target)this.target), TaskValidatorsUtils.notBlankStringValidation((String)this.destination, (String)"destination"), TaskValidatorsUtils.notBlankStringValidation((String)this.body, (String)"body")});
    }

    public TaskExecutionResult execute() {
        TaskExecutionResult taskExecutionResult;
        block8: {
            CloseableResource<JmsConnectionFactory.MessageSender> producer = this.jmsConnectionFactory.getMessageProducer(this.target, this.destination);
            try {
                ((JmsConnectionFactory.MessageSender)producer.getResource()).send(this.body, this.headers);
                this.logger.info("Successfully sent message on " + this.destination + " to " + this.target.name() + " (" + this.target.url() + ")");
                taskExecutionResult = TaskExecutionResult.ok();
                if (producer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (producer != null) {
                        try {
                            producer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedJmsException | JMSException e) {
                    this.logger.error(e);
                    return TaskExecutionResult.ko();
                }
            }
            producer.close();
        }
        return taskExecutionResult;
    }
}

