/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms;

import com.chutneytesting.task.jms.UncheckedJmsException;
import com.chutneytesting.task.jms.consumer.Consumer;
import com.chutneytesting.task.jms.consumer.ConsumerFactory;
import com.chutneytesting.task.jms.consumer.JmsListenerParameters;
import com.chutneytesting.task.spi.injectable.SecurityInfo;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.chutneytesting.tools.Entry;
import com.chutneytesting.tools.ThrowingFunction;
import com.chutneytesting.tools.ThrowingSupplier;
import com.chutneytesting.tools.UncheckedException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnectionFactory.class);

    public CloseableResource<Consumer> createConsumer(Target target, JmsListenerParameters arguments) {
        ConsumerFactory consumerFactory = new ConsumerFactory(arguments);
        return this.obtainCloseableResource(target, arguments.destination, consumerFactory::build);
    }

    public CloseableResource<MessageSender> getMessageProducer(Target target, String destinationName) throws UncheckedJmsException {
        return this.obtainCloseableResource(target, destinationName, (session, destination) -> {
            MessageProducer messageProducer = session.createProducer(destination);
            return (messageContent, headers) -> {
                TextMessage message = session.createTextMessage(messageContent);
                for (Map.Entry headerEntry : headers.entrySet()) {
                    message.setStringProperty((String)headerEntry.getKey(), (String)headerEntry.getValue());
                }
                messageProducer.send((Message)message);
            };
        });
    }

    private <T> CloseableResource<T> obtainCloseableResource(Target target, String destinationName, JmsThrowingBiFunction<Session, Destination, T> resourceBuilder) throws UncheckedJmsException {
        Hashtable<String, String> environmentProperties = new Hashtable<String, String>();
        environmentProperties.put("java.naming.provider.url", target.url());
        environmentProperties.putAll(target.properties());
        this.configureSsl(target, environmentProperties);
        String connectionFactoryName = target.properties().getOrDefault("connectionFactoryName", "ConnectionFactory");
        try {
            this.debugClassLoader();
            InitialContext context = new InitialContext(environmentProperties);
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(connectionFactoryName);
            Connection connection = this.createConnection(connectionFactory, target.security().credential());
            connection.start();
            Session session = connection.createSession(false, 1);
            Destination destination = (Destination)context.lookup(destinationName);
            return CloseableResource.build(resourceBuilder.apply(session, destination), () -> {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.warn("Unable to close JMS Session: " + e.getMessage());
                }
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    LOGGER.warn("Unable to close JMS Connection: " + e.getMessage());
                }
            });
        }
        catch (InvalidSelectorException e) {
            throw new UncheckedJmsException("Cannot parse selector " + e.getMessage(), (Exception)((Object)e));
        }
        catch (NameNotFoundException e) {
            throw new UncheckedJmsException("Cannot find destination " + e.getMessage() + " on jms server " + target.name() + " (" + target.url() + ")", e);
        }
        catch (JMSException | NamingException e) {
            throw new UncheckedJmsException("Cannot connect to jms server " + target.name() + " (" + target.url() + "): " + e.getMessage(), (Exception)e);
        }
    }

    private void debugClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Thread.currentThread().getContextClassLoader(): " + contextClassLoader);
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        LOGGER.debug("ClassLoader.getSystemClassLoader(): " + systemClassLoader);
    }

    private Connection createConnection(ConnectionFactory connectionFactory, Optional<SecurityInfo.Credential> optionalCredential) throws JMSException {
        try {
            return (Connection)optionalCredential.map(ThrowingFunction.toUnchecked(credential -> connectionFactory.createConnection(credential.username(), credential.password()))).orElseGet(ThrowingSupplier.toUnchecked(() -> connectionFactory.createConnection()));
        }
        catch (UncheckedException e) {
            throw (JMSException)e.getCause();
        }
    }

    private void configureSsl(Target target, Hashtable<String, String> environmentProperties) {
        target.security().keyStore().ifPresent(keyStore -> environmentProperties.put("connection.ConnectionFactory.keyStore", (String)keyStore));
        target.security().keyStorePassword().ifPresent(keyStorePassword -> environmentProperties.put("connection.ConnectionFactory.keyStorePassword", (String)keyStorePassword));
        target.security().keyPassword().or(() -> Entry.toEntryList((Map)target.properties()).stream().filter(e -> e.key.equalsIgnoreCase("keyPassword")).findFirst().map(e -> e.value)).ifPresent(keyStoreKeyPassword -> environmentProperties.put("connection.ConnectionFactory.keyStoreKeyPassword", (String)keyStoreKeyPassword));
        target.security().trustStore().ifPresent(trustStore -> environmentProperties.put("connection.ConnectionFactory.trustStore", (String)trustStore));
        target.security().trustStorePassword().ifPresent(trustStorePassword -> environmentProperties.put("connection.ConnectionFactory.trustStorePassword", (String)trustStorePassword));
    }

    public static interface MessageSender {
        public void send(String var1, Map<String, String> var2) throws JMSException;
    }

    private static interface JmsThrowingBiFunction<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws JMSException;
    }
}

