/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh.sshd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.sshd.server.SshServer;

public class SshServerMock {
    private final SshServer sshServer;
    private final List<String> stubs;
    private final List<Boolean> usedStubs;
    private final List<String> commands = new ArrayList<String>();

    public SshServerMock(SshServer sshServer, List<String> stubs) {
        this.sshServer = sshServer;
        this.stubs = stubs;
        this.usedStubs = stubs.stream().map(s -> false).collect(Collectors.toList());
    }

    public Optional<String> addCommand(String command) {
        this.commands.add(command);
        int lastCommandIndex = this.commands.size() - 1;
        if (lastCommandIndex < this.stubs.size()) {
            this.usedStubs.set(lastCommandIndex, true);
            return Optional.of(this.stubs.get(lastCommandIndex));
        }
        return Optional.empty();
    }

    public List<String> commands() {
        return Collections.unmodifiableList(this.commands);
    }

    public List<String> stubs() {
        return Collections.unmodifiableList(this.stubs);
    }

    public String command(int i) {
        return this.commands.get(i);
    }

    public boolean allStubsUsed() {
        return this.usedStubs.stream().reduce((b1, b2) -> b1 != false && b2 != false).orElse(false);
    }

    public void start() throws IOException {
        this.sshServer.start();
    }

    public void stop() throws IOException {
        this.sshServer.stop();
    }

    public String host() {
        return this.sshServer.getHost();
    }

    public int port() {
        return this.sshServer.getPort();
    }

    public boolean isStarted() {
        return this.sshServer.isStarted();
    }

    public boolean isClosed() {
        return this.sshServer.isClosed();
    }
}

