/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.sql.core.DefaultSqlClientFactory;
import com.chutneytesting.task.sql.core.SqlClient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class SqlTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final List<String> statements;
    private final DefaultSqlClientFactory clientFactory = new DefaultSqlClientFactory();

    public SqlTask(Target target, Logger logger, @Input(value="statements") List<String> statements) {
        this.target = target;
        this.logger = logger;
        this.statements = statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutionResult execute() {
        SqlClient sqlClient = this.clientFactory.create(this.target);
        try {
            ArrayList records = new ArrayList();
            HashMap outputs = new HashMap();
            AtomicBoolean failure = new AtomicBoolean(false);
            this.statements.stream().forEach(statement -> {
                try {
                    records.add(sqlClient.execute((String)statement));
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage() + " for " + statement + "; Vendor error code: " + e.getErrorCode());
                    records.add(sqlClient.emptyRecords());
                    failure.set(true);
                }
            });
            outputs.put("recordResult", records);
            TaskExecutionResult taskExecutionResult = failure.get() ? TaskExecutionResult.ko(outputs) : TaskExecutionResult.ok(outputs);
            return taskExecutionResult;
        }
        finally {
            if (sqlClient != null) {
                sqlClient.closeDatasource();
            }
        }
    }
}

