/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MicrometerTimerTask
implements Task {
    protected static final String OUTPUT_TIMER = "micrometerTimer";
    private final Logger logger;
    private final String name;
    private final String description;
    private final List<String> tags;
    private final Integer bufferLength;
    private final Duration expiry;
    private final Duration maxValue;
    private final Duration minValue;
    private final Integer percentilePrecision;
    private final Boolean publishPercentilesHistogram;
    private final double[] percentiles;
    private final Duration[] sla;
    private Timer timer;
    private final MeterRegistry registry;
    private final TimeUnit timeunit;
    private final Duration record;

    public MicrometerTimerTask(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="tags") List<String> tags, @Input(value="bufferLength") String bufferLength, @Input(value="expiry") String expiry, @Input(value="maxValue") String maxValue, @Input(value="minValue") String minValue, @Input(value="percentilePrecision") String percentilePrecision, @Input(value="publishPercentilesHistogram") Boolean publishPercentilesHistogram, @Input(value="percentiles") String percentiles, @Input(value="sla") String sla, @Input(value="timer") Timer timer, @Input(value="registry") MeterRegistry registry, @Input(value="timeunit") String timeunit, @Input(value="record") String record) {
        this.logger = logger;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.bufferLength = MicrometerTaskHelper.checkIntOrNull(bufferLength);
        this.expiry = MicrometerTaskHelper.checkDurationOrNull(expiry);
        this.maxValue = MicrometerTaskHelper.checkDurationOrNull(maxValue);
        this.minValue = MicrometerTaskHelper.checkDurationOrNull(minValue);
        this.percentilePrecision = MicrometerTaskHelper.checkIntOrNull(percentilePrecision);
        this.publishPercentilesHistogram = publishPercentilesHistogram;
        this.percentiles = MicrometerTaskHelper.checkMapOrNull(percentiles, MicrometerTaskHelper::parsePercentilesList);
        this.sla = MicrometerTaskHelper.checkMapOrNull(sla, MicrometerTaskHelper::parseSlaListToDurations);
        this.timeunit = MicrometerTaskHelper.checkTimeUnit(timeunit);
        this.record = MicrometerTaskHelper.checkDurationOrNull(record);
        this.timer = timer;
        this.registry = registry;
    }

    public TaskExecutionResult execute() {
        try {
            this.timer = Optional.ofNullable(this.timer).orElseGet(() -> this.retrieveTimer(this.registry));
            if (this.record != null) {
                this.timer.record(this.record);
                this.logger.info("Timer updated by " + this.record);
            }
            MicrometerTaskHelper.logTimerState(this.logger, this.timer, this.timeunit);
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_TIMER, this.timer));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private Timer retrieveTimer(MeterRegistry registry) {
        MeterRegistry registryToUse = MicrometerTaskHelper.checkRegistry(registry);
        Timer.Builder builder = Timer.builder((String)Objects.requireNonNull(this.name)).description(this.description).distributionStatisticBufferLength(this.bufferLength).distributionStatisticExpiry(this.expiry).maximumExpectedValue(this.maxValue).minimumExpectedValue(this.minValue).percentilePrecision(this.percentilePrecision).publishPercentileHistogram(this.publishPercentilesHistogram).publishPercentiles(this.percentiles).sla(this.sla);
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registryToUse);
    }
}

