/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion.placeholder;

import com.chutneytesting.task.assertion.placeholder.AfterDateAsserter;
import com.chutneytesting.task.assertion.placeholder.BeforeDateAsserter;
import com.chutneytesting.task.assertion.placeholder.ContainsAsserter;
import com.chutneytesting.task.assertion.placeholder.EqualDateAsserter;
import com.chutneytesting.task.assertion.placeholder.GreaterThanAsserter;
import com.chutneytesting.task.assertion.placeholder.IsNullAsserter;
import com.chutneytesting.task.assertion.placeholder.LessThanAsserter;
import com.chutneytesting.task.assertion.placeholder.MatchesStringAsserter;
import com.chutneytesting.task.assertion.placeholder.NotNullAsserter;
import com.chutneytesting.task.assertion.placeholder.PlaceholderAsserter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PlaceholderAsserterUtils {
    private static final List<PlaceholderAsserter> asserters = new ArrayList<PlaceholderAsserter>();

    public static final Optional<PlaceholderAsserter> getAsserterMatching(Object toMatch) {
        if (toMatch == null) {
            return Optional.of(new IsNullAsserter());
        }
        return asserters.stream().filter(a -> a.canApply(toMatch.toString())).findFirst();
    }

    static {
        asserters.add(new IsNullAsserter());
        asserters.add(new NotNullAsserter());
        asserters.add(new ContainsAsserter());
        asserters.add(new BeforeDateAsserter());
        asserters.add(new AfterDateAsserter());
        asserters.add(new EqualDateAsserter());
        asserters.add(new MatchesStringAsserter());
        asserters.add(new LessThanAsserter());
        asserters.add(new GreaterThanAsserter());
    }
}

