/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.amqp.ConnectionFactoryFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class AmqpBasicPublishTask
implements Task {
    private static final String CONTENT_TYPE = "content_type";
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final ConnectionFactory connectionFactory;
    private final String exchangeName;
    private final String routingKey;
    private final Map<String, Object> headers;
    private final Map<String, String> properties;
    private final String payload;
    private final Logger logger;

    public AmqpBasicPublishTask(Target target, @Input(value="exchange-name") String exchangeName, @Input(value="routing-key") String routingKey, @Input(value="headers") Map<String, Object> headers, @Input(value="properties") Map<String, String> properties, @Input(value="payload") String payload, Logger logger) {
        this.connectionFactory = this.connectionFactoryFactory.create(target);
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.headers = headers != null ? headers : Collections.emptyMap();
        this.properties = properties != null ? properties : Collections.emptyMap();
        this.payload = payload;
        this.logger = logger;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (Connection connection = this.connectionFactory.newConnection();){
            TaskExecutionResult taskExecutionResult;
            block14: {
                Channel channel = connection.createChannel();
                try {
                    AMQP.BasicProperties basicProperties = this.buildProperties();
                    channel.basicPublish(this.exchangeName, this.routingKey, basicProperties, this.payload.getBytes());
                    this.logger.info("Published AMQP Message on " + this.exchangeName + " with routing key: " + this.routingKey);
                    taskExecutionResult = TaskExecutionResult.ok(this.outputs(basicProperties, this.payload));
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return taskExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
    }

    public Map<String, Object> outputs(AMQP.BasicProperties basicProperties, String payload) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("payload", payload);
        results.put("headers", basicProperties.getHeaders().entrySet().stream().map(Object::toString).collect(Collectors.joining(";", "[", "]")));
        return results;
    }

    private AMQP.BasicProperties buildProperties() {
        AMQP.BasicProperties.Builder basicPropertiesBuilder = new AMQP.BasicProperties.Builder().appId("testing-app");
        if (this.properties.containsKey(CONTENT_TYPE)) {
            basicPropertiesBuilder.contentType(this.properties.get(CONTENT_TYPE));
        }
        basicPropertiesBuilder.headers(this.headers);
        return basicPropertiesBuilder.build();
    }
}

