/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh;

import com.chutneytesting.task.spi.time.Duration;
import com.chutneytesting.task.ssh.CommandResult;
import com.chutneytesting.task.ssh.SshClient;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Optional;

public class Command {
    private static final Duration DEFAULT_DURATION = Duration.parse((String)"5000 ms");
    public final String command;
    public final Duration timeout;

    Command(String command) {
        this.command = command;
        this.timeout = DEFAULT_DURATION;
    }

    Command(String command, String timeout) {
        this.command = command;
        this.timeout = Optional.ofNullable(timeout).map(Duration::parse).orElse(DEFAULT_DURATION);
    }

    CommandResult executeWith(SshClient sshClient) throws IOException {
        return sshClient.execute(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("command", (Object)this.command).add("timeout", (Object)this.timeout).toString();
    }
}

