/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql.core;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Records {
    public final int affectedRows;
    public final List<String> headers;
    public final List<List<Object>> rows;

    Records(int affectedRows, List<String> headers, List<List<Object>> rows) {
        this.affectedRows = affectedRows;
        this.headers = headers;
        this.rows = rows;
    }

    public List<Map<String, Object>> toListOfMaps() {
        ArrayList<Map<String, Object>> listOfMaps = new ArrayList<Map<String, Object>>(this.rows.size());
        for (List<Object> row : this.rows) {
            LinkedHashMap<String, Object> aRow = new LinkedHashMap<String, Object>(this.headers.size());
            for (int j = 0; j < this.headers.size(); ++j) {
                aRow.put(this.headers.get(j), row.get(j));
            }
            listOfMaps.add(aRow);
        }
        return listOfMaps;
    }

    public Object[][] toMatrix() {
        Object[][] matrix = new Object[this.rows.size()][this.headers.size()];
        for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.headers.size(); ++columnIndex) {
                matrix[rowIndex][columnIndex] = this.rows.get(rowIndex).get(columnIndex);
            }
        }
        return matrix;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("affectedRows", this.affectedRows).add("headers", this.headers).add("rows", this.rows).toString();
    }
}

