/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.selenium;

import com.chutneytesting.task.selenium.SeleniumTask;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Set;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class SeleniumGetTask
extends SeleniumTask {
    private static final String SELENIUM_OUTPUTS_KEY = "outputGet";
    private final String selector;
    private final String value;

    public SeleniumGetTask(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="value") String value) {
        super(logger, webDriver);
        this.selector = selector;
        this.value = value;
    }

    @Override
    public TaskExecutionResult executeSeleniumTask() {
        if (this.selector != null) {
            Set<String> afterAllCurrentWindowHandles = this.getNewWindowHandle(this.webDriver);
            this.webDriver.switchTo().window((String)afterAllCurrentWindowHandles.toArray()[0]);
            this.logger.info("Switch to new window");
        }
        this.logger.info("Get url : " + this.value);
        this.webDriver.get(this.value);
        return TaskExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)this.webDriver.getWindowHandle());
    }

    private Set<String> getNewWindowHandle(WebDriver webDriver) {
        Set allCurrentWindowHandles = webDriver.getWindowHandles();
        ((JavascriptExecutor)webDriver).executeScript("window.open();", new Object[0]);
        Set afterAllCurrentWindowHandles = webDriver.getWindowHandles();
        afterAllCurrentWindowHandles.removeAll(allCurrentWindowHandles);
        return afterAllCurrentWindowHandles;
    }
}

