/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.selenium;

import com.chutneytesting.task.selenium.SeleniumFindBehavior;
import com.chutneytesting.task.selenium.SeleniumTask;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;

public class SeleniumWaitTask
extends SeleniumTask
implements SeleniumFindBehavior {
    private final String selector;
    private final String by;
    private final Integer wait;
    private final String value;

    public SeleniumWaitTask(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait, @Input(value="value") String value) {
        super(logger, webDriver);
        this.value = value;
        this.selector = selector;
        this.by = by;
        this.wait = wait;
    }

    @Override
    public TaskExecutionResult executeSeleniumTask() {
        Optional webElement = this.by(this.webDriver, this.selector, this.by);
        if (!webElement.isPresent()) {
            this.logger.error("Cannot find condition from parameters.");
            return TaskExecutionResult.ko();
        }
        ExpectedByCondition expectedByCondition = new ExpectedByCondition(this.value);
        FluentWait explicitWait = new FluentWait((Object)this.webDriver).withTimeout(Duration.of(this.wait != null ? this.wait.longValue() : 2L, ChronoUnit.SECONDS)).pollingEvery(Duration.of(500L, ChronoUnit.MILLIS));
        explicitWait.until(expectedByCondition.toExpectedCondition((By)webElement.get()));
        return TaskExecutionResult.ok();
    }

    private static enum ExpectedByConditionEnum {
        ELEMENT_TO_BE_SELECTED("elementToBeSelected"),
        ELEMENT_TO_BE_CLICKABLE("elementToBeClickable"),
        FRAME_TO_BE_AVALAIBLE_AND_SWITCH_TO_IT("frameToBeAvailableAndSwitchToIt"),
        INVISIBILITY_OF_ELEMENT_LOCATED("invisibilityOfElementLocated"),
        VISIBILITY_OF_ELEMENT_LOCATED("visibilityOfElementLocated"),
        VISIBILITY_OF_ALL_ELEMENT_LOCATED("visibilityOfAllElementLocated"),
        PRESENCE_OF_ELEMENT_LOCATED("presenceOfElementLocated"),
        PRESENCE_OF_ALL_ELEMENT_LOCATED("presenceOfAllElementLocated"),
        AND("and"),
        OR("or"),
        NOT("not");

        public final String name;

        private ExpectedByConditionEnum(String name) {
            this.name = name;
        }

        static ExpectedByConditionEnum findByName(String name) {
            for (ExpectedByConditionEnum expectedByConditionEnum : ExpectedByConditionEnum.values()) {
                if (!expectedByConditionEnum.name.equals(name)) continue;
                return expectedByConditionEnum;
            }
            throw new IllegalArgumentException("Unknown ExpectedByConditionEnum name.");
        }
    }

    private class ExpectedByCondition {
        private final Pattern LOGIC_FUNCTION_PATTERN = Pattern.compile("(and|or|not)\\((.*)\\)");
        private final ExpectedByConditionEnum expectedByConditionEnum;
        private final List<ExpectedByCondition> expectedByConditions;

        ExpectedByCondition(String expectedByCondition) {
            Matcher logicFunctionMatcher = this.LOGIC_FUNCTION_PATTERN.matcher(expectedByCondition);
            if (logicFunctionMatcher.find()) {
                this.expectedByConditionEnum = ExpectedByConditionEnum.findByName(logicFunctionMatcher.group(1));
                this.expectedByConditions = ((Stream)Arrays.stream(logicFunctionMatcher.group(2).split(",")).parallel()).map(x$0 -> new ExpectedByCondition((String)x$0)).collect(Collectors.toList());
            } else {
                this.expectedByConditionEnum = ExpectedByConditionEnum.findByName(expectedByCondition);
                this.expectedByConditions = new ArrayList<ExpectedByCondition>();
            }
        }

        ExpectedCondition<?> toExpectedCondition(By by) {
            switch (this.expectedByConditionEnum) {
                case ELEMENT_TO_BE_SELECTED: {
                    return ExpectedConditions.elementToBeSelected((By)by);
                }
                case ELEMENT_TO_BE_CLICKABLE: {
                    return ExpectedConditions.elementToBeClickable((By)by);
                }
                case FRAME_TO_BE_AVALAIBLE_AND_SWITCH_TO_IT: {
                    return ExpectedConditions.frameToBeAvailableAndSwitchToIt((By)by);
                }
                case INVISIBILITY_OF_ELEMENT_LOCATED: {
                    return ExpectedConditions.invisibilityOfElementLocated((By)by);
                }
                case VISIBILITY_OF_ELEMENT_LOCATED: {
                    return ExpectedConditions.visibilityOfElementLocated((By)by);
                }
                case VISIBILITY_OF_ALL_ELEMENT_LOCATED: {
                    return ExpectedConditions.visibilityOfAllElementsLocatedBy((By)by);
                }
                case PRESENCE_OF_ELEMENT_LOCATED: {
                    return ExpectedConditions.presenceOfElementLocated((By)by);
                }
                case PRESENCE_OF_ALL_ELEMENT_LOCATED: {
                    return ExpectedConditions.presenceOfAllElementsLocatedBy((By)by);
                }
                case AND: {
                    return ExpectedConditions.and((ExpectedCondition[])((ExpectedCondition[])this.expectedByConditions.parallelStream().map(expectedByCondition -> expectedByCondition.toExpectedCondition(by)).collect(Collectors.toList()).toArray()));
                }
                case OR: {
                    return ExpectedConditions.or((ExpectedCondition[])((ExpectedCondition[])this.expectedByConditions.parallelStream().map(expectedByCondition -> expectedByCondition.toExpectedCondition(by)).collect(Collectors.toList()).toArray()));
                }
                case NOT: {
                    return ExpectedConditions.not(this.expectedByConditions.get(0).toExpectedCondition(by));
                }
            }
            return null;
        }
    }
}

