/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.selenium;

import com.chutneytesting.task.selenium.SeleniumFindBehavior;
import com.chutneytesting.task.selenium.SeleniumTask;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Optional;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class SeleniumScrollToTask
extends SeleniumTask
implements SeleniumFindBehavior {
    private final String selector;
    private final String by;
    private final Integer wait;

    public SeleniumScrollToTask(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
    }

    @Override
    public TaskExecutionResult executeSeleniumTask() {
        Optional webElement = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        if (webElement.isPresent()) {
            ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].scrollIntoView(true);", new Object[]{webElement.get()});
            this.logger.info("Scroll to element : " + webElement.get());
            return TaskExecutionResult.ok();
        }
        this.logger.error("Cannot retrieve element to scroll.");
        return TaskExecutionResult.ko();
    }
}

