/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.google.common.base.Ascii;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;

public class MongoInsertTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String document;

    public MongoInsertTask(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="document") String document) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.document = document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);){
            ((MongoDatabase)database.getResource()).getCollection(this.collection).insertOne((Object)Document.parse((String)this.document));
            this.logger.info("Inserted in Mongo collection '" + this.collection + "':\n\t" + Ascii.truncate((CharSequence)this.document.replace("\n", "\n\t"), (int)50, (String)"..."));
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok();
            return taskExecutionResult;
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

