/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.groovy;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyTask
implements Task {
    private final String scriptAsString;
    private final Map<String, Object> parameters;
    private final Logger logger;

    public GroovyTask(@Input(value="script") String scriptAsString, @Input(value="parameters") Map<String, Object> parameters, Logger logger) {
        this.scriptAsString = scriptAsString;
        this.parameters = parameters;
        this.logger = logger;
    }

    public TaskExecutionResult execute() {
        try {
            Script script = new GroovyShell().parse(this.scriptAsString);
            script.setBinding(this.getBindingFromMap(this.parameters));
            Map result = (Map)script.run();
            return TaskExecutionResult.ok((Map)result);
        }
        catch (CompilationFailedException e) {
            this.logger.error("Cannot compile groovy script : " + e.getMessage());
            return TaskExecutionResult.ko();
        }
        catch (RuntimeException e) {
            this.logger.error("Groovy script failed during execution: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
    }

    private Binding getBindingFromMap(Map<String, Object> variables) {
        Binding binding = new Binding();
        variables.forEach((k, v) -> binding.setVariable(k, v));
        binding.setVariable("logger", (Object)this.logger);
        return binding;
    }
}

