/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security;

import com.chutneytesting.security.api.UserDto;
import com.chutneytesting.security.domain.AuthenticationService;
import com.chutneytesting.security.domain.Authorizations;
import com.chutneytesting.security.infra.handlers.Http401FailureHandler;
import com.chutneytesting.security.infra.handlers.HttpEmptyLogoutSuccessHandler;
import com.chutneytesting.security.infra.handlers.HttpLoginSuccessHandler;
import com.chutneytesting.server.core.domain.security.Authorization;
import com.chutneytesting.server.core.domain.security.User;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class ChutneyWebSecurityConfig {
    public static final String LOGIN_URL = "/api/v1/user/login";
    public static final String LOGOUT_URL = "/api/v1/user/logout";
    public static final String API_BASE_URL_PATTERN = "/api/**";
    @Value(value="${management.endpoints.web.base-path:/actuator}")
    String actuatorBaseUrl;

    @Bean
    public AuthenticationService authenticationService(Authorizations authorizations) {
        return new AuthenticationService(authorizations);
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        this.configureBaseHttpSecurity(http);
        UserDto anonymous = this.anonymous();
        http.anonymous(anonymousConfigurer -> anonymousConfigurer.principal((Object)anonymous).authorities(new ArrayList<GrantedAuthority>(anonymous.getAuthorities()))).authorizeHttpRequests(httpRequest -> {
            HandlerMappingIntrospector introspector = new HandlerMappingIntrospector();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)httpRequest.requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, LOGIN_URL)})).permitAll().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, LOGOUT_URL)})).permitAll().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, "/api/v1/info/**")})).permitAll().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, API_BASE_URL_PATTERN)})).authenticated().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, this.actuatorBaseUrl + "/**")})).hasAuthority(Authorization.ADMIN_ACCESS.name()).anyRequest()).permitAll();
        }).httpBasic(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    protected void configureBaseHttpSecurity(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).exceptionHandling(httpSecurityExceptionHandlingConfigurer -> httpSecurityExceptionHandlingConfigurer.authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED))).requiresChannel(channelRequestMatcherRegistry -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channelRequestMatcherRegistry.anyRequest()).requiresSecure()).formLogin(httpSecurityFormLoginConfigurer -> ((FormLoginConfigurer)((FormLoginConfigurer)httpSecurityFormLoginConfigurer.loginProcessingUrl(LOGIN_URL)).successHandler((AuthenticationSuccessHandler)new HttpLoginSuccessHandler())).failureHandler((AuthenticationFailureHandler)new Http401FailureHandler())).logout(httpSecurityLogoutConfigurer -> httpSecurityLogoutConfigurer.logoutUrl(LOGOUT_URL).logoutSuccessHandler((LogoutSuccessHandler)new HttpEmptyLogoutSuccessHandler()));
    }

    protected UserDto anonymous() {
        UserDto anonymous = new UserDto();
        anonymous.setId(User.ANONYMOUS.id);
        anonymous.setName(User.ANONYMOUS.id);
        anonymous.grantAuthority("ANONYMOUS");
        return anonymous;
    }
}

