/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.storage;

import com.chutneytesting.campaign.infra.CampaignExecutionJpaRepository;
import com.chutneytesting.campaign.infra.CampaignJpaRepository;
import com.chutneytesting.campaign.infra.jpa.CampaignEntity;
import com.chutneytesting.campaign.infra.jpa.CampaignExecutionEntity;
import com.chutneytesting.execution.infra.storage.DatabaseExecutionJpaRepository;
import com.chutneytesting.execution.infra.storage.ScenarioExecutionReportJpaRepository;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecutionEntity;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecutionReportEntity;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ReportNotFoundException;
import com.chutneytesting.server.core.domain.execution.report.ScenarioExecutionReport;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.execution.report.StepExecutionReportCore;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
class DatabaseExecutionHistoryRepository
implements ExecutionHistoryRepository {
    private final DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository;
    private final ScenarioExecutionReportJpaRepository scenarioExecutionReportJpaRepository;
    private final CampaignJpaRepository campaignJpaRepository;
    private final CampaignExecutionJpaRepository campaignExecutionJpaRepository;
    private final TestCaseRepository testCaseRepository;
    private final ObjectMapper objectMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseExecutionHistoryRepository.class);

    DatabaseExecutionHistoryRepository(DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository, ScenarioExecutionReportJpaRepository scenarioExecutionReportJpaRepository, CampaignJpaRepository campaignJpaRepository, TestCaseRepository testCaseRepository, CampaignExecutionJpaRepository campaignExecutionJpaRepository, @Qualifier(value="reportObjectMapper") ObjectMapper objectMapper) {
        this.scenarioExecutionsJpaRepository = scenarioExecutionsJpaRepository;
        this.scenarioExecutionReportJpaRepository = scenarioExecutionReportJpaRepository;
        this.campaignJpaRepository = campaignJpaRepository;
        this.testCaseRepository = testCaseRepository;
        this.campaignExecutionJpaRepository = campaignExecutionJpaRepository;
        this.objectMapper = objectMapper;
    }

    public Map<String, ExecutionHistory.ExecutionSummary> getLastExecutions(List<String> scenariosIds) {
        List<String> validScenariosIds = scenariosIds.stream().filter(id -> !this.invalidScenarioId((String)id)).toList();
        List<Long> executionsIds = this.scenarioExecutionsJpaRepository.findLastByStatusAndScenariosIds(validScenariosIds, ServerReportStatus.RUNNING).stream().map(t -> (Long)t.get(0, Long.class)).toList();
        List lastExecutions = this.scenarioExecutionsJpaRepository.findAllById(executionsIds);
        return StreamSupport.stream(lastExecutions.spliterator(), true).collect(Collectors.toMap(ScenarioExecutionEntity::scenarioId, ScenarioExecutionEntity::toDomain));
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutions(String scenarioId) {
        if (this.invalidScenarioId(scenarioId)) {
            return Collections.emptyList();
        }
        List<ScenarioExecutionEntity> scenarioExecutions = this.scenarioExecutionsJpaRepository.findByScenarioIdOrderByIdDesc(scenarioId);
        return scenarioExecutions.stream().map(this::scenarioExecutionToExecutionSummary).toList();
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutions() {
        return this.scenarioExecutionsJpaRepository.findAll().stream().map(this::scenarioExecutionToExecutionSummary).toList();
    }

    public ExecutionHistory.ExecutionSummary getExecutionSummary(Long executionId) {
        return this.scenarioExecutionsJpaRepository.findById(executionId).map(this::scenarioExecutionToExecutionSummary).orElseThrow(() -> new ReportNotFoundException(executionId));
    }

    private ExecutionHistory.ExecutionSummary scenarioExecutionToExecutionSummary(ScenarioExecutionEntity scenarioExecution) {
        CampaignExecution campaignExecution = Optional.ofNullable(scenarioExecution.campaignExecution()).map(ce -> ce.toDomain((CampaignEntity)this.campaignJpaRepository.findById(ce.campaignId()).get(), false, null)).orElse(null);
        return scenarioExecution.toDomain(campaignExecution);
    }

    @Transactional
    public ExecutionHistory.Execution store(String scenarioId, ExecutionHistory.DetachedExecution detachedExecution) throws IllegalStateException {
        if (this.invalidScenarioId(scenarioId)) {
            throw new IllegalStateException("Scenario id is null or empty");
        }
        ScenarioExecutionEntity scenarioExecution = ScenarioExecutionEntity.fromDomain(scenarioId, (ExecutionHistory.ExecutionProperties)detachedExecution);
        if (detachedExecution.campaignReport().isPresent()) {
            Optional campaignExecution = this.campaignExecutionJpaRepository.findById((long)((CampaignExecution)detachedExecution.campaignReport().get()).executionId);
            scenarioExecution.forCampaignExecution((CampaignExecutionEntity)campaignExecution.get());
        }
        scenarioExecution = (ScenarioExecutionEntity)this.scenarioExecutionsJpaRepository.save(scenarioExecution);
        this.scenarioExecutionReportJpaRepository.save(new ScenarioExecutionReportEntity(scenarioExecution, detachedExecution.report()));
        ExecutionHistory.Execution execution = detachedExecution.attach(scenarioExecution.id().longValue(), scenarioId);
        return ImmutableExecutionHistory.Execution.builder().from(execution).build();
    }

    public ExecutionHistory.Execution getExecution(String scenarioId, Long reportId) throws ReportNotFoundException {
        if (this.invalidScenarioId(scenarioId) || this.testCaseRepository.findById(scenarioId).isEmpty()) {
            throw new ReportNotFoundException(scenarioId, reportId);
        }
        return this.scenarioExecutionReportJpaRepository.findById(reportId).map(ScenarioExecutionReportEntity::toDomain).orElseThrow(() -> new ReportNotFoundException(scenarioId, reportId));
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutionReportMatchQuery(String query) {
        return this.scenarioExecutionsJpaRepository.getExecutionReportMatchQuery(query).stream().map(this::scenarioExecutionToExecutionSummary).toList();
    }

    @Transactional
    public void update(String scenarioId, ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        if (!this.scenarioExecutionsJpaRepository.existsById(updatedExecution.executionId())) {
            throw new ReportNotFoundException(scenarioId, updatedExecution.executionId());
        }
        this.update(updatedExecution);
    }

    private void update(ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        ScenarioExecutionEntity execution = (ScenarioExecutionEntity)this.scenarioExecutionsJpaRepository.findById(updatedExecution.executionId()).orElseThrow(() -> new ReportNotFoundException(updatedExecution.executionId()));
        execution.updateFromExecution(updatedExecution);
        this.scenarioExecutionsJpaRepository.save(execution);
        this.updateReport(updatedExecution);
    }

    private void updateReport(ExecutionHistory.Execution execution) throws ReportNotFoundException {
        ScenarioExecutionReportEntity scenarioExecutionReport = (ScenarioExecutionReportEntity)this.scenarioExecutionReportJpaRepository.findById(execution.executionId()).orElseThrow(() -> new ReportNotFoundException(execution.executionId()));
        scenarioExecutionReport.updateReport(execution);
        this.scenarioExecutionReportJpaRepository.save(scenarioExecutionReport);
    }

    @Transactional
    public int setAllRunningExecutionsToKO() {
        List<ExecutionHistory.ExecutionSummary> runningExecutions = this.getExecutionsWithStatus(ServerReportStatus.RUNNING);
        this.updateExecutionsToKO(runningExecutions);
        List<ExecutionHistory.ExecutionSummary> pausedExecutions = this.getExecutionsWithStatus(ServerReportStatus.PAUSED);
        this.updateExecutionsToKO(pausedExecutions);
        return runningExecutions.size() + pausedExecutions.size();
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutionsWithStatus(ServerReportStatus status) {
        return this.scenarioExecutionsJpaRepository.findByStatus(status).stream().map(ScenarioExecutionEntity::toDomain).toList();
    }

    @Transactional
    public void deleteExecutions(Set<Long> executionsIds) {
        this.scenarioExecutionsJpaRepository.deleteAllByIdInBatch(executionsIds);
        this.scenarioExecutionReportJpaRepository.deleteAllById(executionsIds);
    }

    private void updateExecutionsToKO(List<ExecutionHistory.ExecutionSummary> executions) {
        executions.stream().map(this::buildKnockoutExecutionFrom).forEach(this::update);
    }

    private ImmutableExecutionHistory.Execution buildKnockoutExecutionFrom(ExecutionHistory.ExecutionSummary executionSummary) {
        String reportStoppedRunningOrPausedStatus = this.stopRunningOrPausedReport(executionSummary);
        return ImmutableExecutionHistory.Execution.builder().executionId(executionSummary.executionId()).status(ServerReportStatus.FAILURE).time(executionSummary.time()).duration(executionSummary.duration()).info(executionSummary.info()).error("Execution was interrupted !").report(reportStoppedRunningOrPausedStatus).testCaseTitle(executionSummary.testCaseTitle()).environment(executionSummary.environment()).user(executionSummary.user()).scenarioId(executionSummary.scenarioId()).build();
    }

    private String stopRunningOrPausedReport(ExecutionHistory.ExecutionSummary executionSummary) {
        return this.scenarioExecutionReportJpaRepository.findById(executionSummary.executionId()).map(ScenarioExecutionReportEntity::toDomain).map(execution -> {
            try {
                ScenarioExecutionReport newScenarioExecutionReport = this.updateStatusInScenarioExecutionReportWithStoppedStatusIfRunningOrPaused((ExecutionHistory.Execution)execution);
                return this.objectMapper.writeValueAsString((Object)newScenarioExecutionReport);
            }
            catch (JsonProcessingException exception) {
                LOGGER.error("Unexpected error while deserializing report for execution id " + executionSummary.executionId(), (Throwable)exception);
                return "";
            }
        }).orElseGet(() -> {
            LOGGER.warn("Report not found for execution id {}", (Object)executionSummary.executionId());
            return "";
        });
    }

    private ScenarioExecutionReport updateStatusInScenarioExecutionReportWithStoppedStatusIfRunningOrPaused(ExecutionHistory.Execution execution) throws JsonProcessingException {
        ScenarioExecutionReport scenarioExecutionReport = (ScenarioExecutionReport)this.objectMapper.readValue(execution.report(), ScenarioExecutionReport.class);
        StepExecutionReportCore report = this.updateStepWithStoppedStatusIfRunningOrPaused(scenarioExecutionReport.report);
        return this.updateScenarioExecutionReport(scenarioExecutionReport, report);
    }

    private ScenarioExecutionReport updateScenarioExecutionReport(ScenarioExecutionReport scenarioExecutionReport, StepExecutionReportCore report) {
        return new ScenarioExecutionReport(scenarioExecutionReport.executionId, scenarioExecutionReport.scenarioName, scenarioExecutionReport.environment, scenarioExecutionReport.user, report);
    }

    private List<StepExecutionReportCore> updateStepListWithStoppedStatusIfRunningOrPaused(List<StepExecutionReportCore> steps) {
        return steps.stream().map(this::updateStepWithStoppedStatusIfRunningOrPaused).collect(Collectors.toList());
    }

    private boolean isExecutionRunningOrPaused(ServerReportStatus status) {
        return status.equals((Object)ServerReportStatus.RUNNING) || status.equals((Object)ServerReportStatus.PAUSED);
    }

    private StepExecutionReportCore updateStepWithStoppedStatusIfRunningOrPaused(StepExecutionReportCore step) {
        ServerReportStatus status = this.isExecutionRunningOrPaused(step.status) ? ServerReportStatus.STOPPED : step.status;
        List<StepExecutionReportCore> steps = this.updateStepListWithStoppedStatusIfRunningOrPaused(step.steps);
        return new StepExecutionReportCore(step.name, step.duration, step.startDate, status, step.information, step.errors, steps, step.type, step.targetName, step.targetUrl, step.strategy, step.evaluatedInputs, step.stepOutputs);
    }

    private boolean invalidScenarioId(String scenarioId) {
        return Strings.isNullOrEmpty((String)scenarioId);
    }
}

