/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api;

import com.chutneytesting.dataset.domain.DataSetRepository;
import com.chutneytesting.environment.api.environment.EmbeddedEnvironmentApi;
import com.chutneytesting.execution.api.IdeaRequest;
import com.chutneytesting.execution.api.ScenarioExecutionReportMapper;
import com.chutneytesting.execution.domain.GwtScenarioMarshaller;
import com.chutneytesting.scenario.api.raw.mapper.GwtScenarioMapper;
import com.chutneytesting.scenario.domain.gwt.GwtScenario;
import com.chutneytesting.scenario.domain.gwt.GwtTestCase;
import com.chutneytesting.security.infra.SpringUserService;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.ScenarioExecutionEngine;
import com.chutneytesting.server.core.domain.execution.ScenarioExecutionEngineAsync;
import com.chutneytesting.server.core.domain.execution.report.ScenarioExecutionReport;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.chutneytesting.tools.ui.MyMixInForIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Observable;
import java.io.IOException;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@CrossOrigin(origins={"*"})
@RestController
public class ScenarioExecutionUiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioExecutionUiController.class);
    private static final GwtScenarioMarshaller marshaller = new GwtScenarioMapper();
    private final ScenarioExecutionEngine executionEngine;
    private final ScenarioExecutionEngineAsync executionEngineAsync;
    private final TestCaseRepository testCaseRepository;
    private final ObjectMapper objectMapper;
    private final ObjectMapper reportObjectMapper;
    private final SpringUserService userService;
    private final DataSetRepository datasetRepository;
    private final ScenarioExecutionReportMapper scenarioExecutionReportMapper;
    private final EmbeddedEnvironmentApi embeddedEnvironmentApi;

    ScenarioExecutionUiController(ScenarioExecutionEngine executionEngine, ScenarioExecutionEngineAsync executionEngineAsync, TestCaseRepository testCaseRepository, ObjectMapper objectMapper, SpringUserService userService, DataSetRepository datasetRepository, ScenarioExecutionReportMapper scenarioExecutionReportMapper, EmbeddedEnvironmentApi embeddedEnvironmentApi) {
        this.executionEngine = executionEngine;
        this.executionEngineAsync = executionEngineAsync;
        this.testCaseRepository = testCaseRepository;
        this.objectMapper = objectMapper;
        this.embeddedEnvironmentApi = embeddedEnvironmentApi;
        this.reportObjectMapper = this.dtoReportObjectMapper();
        this.userService = userService;
        this.datasetRepository = datasetRepository;
        this.scenarioExecutionReportMapper = scenarioExecutionReportMapper;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/idea/scenario/execution/{env}"})
    public String executeScenarioWitRawContent(@RequestBody IdeaRequest ideaRequest, @PathVariable(value="env") String env) throws IOException {
        LOGGER.debug("execute Scenario v2 for content='{}'", (Object)ideaRequest.content());
        String userId = this.userService.currentUser().getId();
        GwtScenario gwtScenario = marshaller.deserialize("test title for idea", "test description for idea", ideaRequest.content());
        GwtTestCase testCase = GwtTestCase.builder().withMetadata(TestCaseMetadataImpl.builder().withDescription("test description for idea").withTitle("test title for idea").build()).withScenario(gwtScenario).build();
        ScenarioExecutionReport report = this.executionEngine.simpleSyncExecution(new ExecutionRequest((TestCase)testCase, env, userId));
        return this.objectMapper.writeValueAsString((Object)report);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/{env}"}, consumes={"application/json"}, produces={"application/json"})
    public String executeScenarioAsyncWithExecutionParameters(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="env") String env) {
        LOGGER.debug("execute async scenario '{}'", (Object)scenarioId);
        TestCase testCase = (TestCase)this.testCaseRepository.findExecutableById(scenarioId).orElseThrow(() -> new ScenarioNotFoundException(scenarioId));
        String userId = this.userService.currentUser().getId();
        DataSet dataset = this.getDataSet(testCase);
        return this.executionEngineAsync.execute(new ExecutionRequest(testCase, env, userId, dataset)).toString();
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}"}, consumes={"application/json"}, produces={"application/json"})
    public String executeScenarioAsyncOnDefaultEnv(@PathVariable(value="scenarioId") String scenarioId) {
        return this.executeScenarioAsyncWithExecutionParameters(scenarioId, this.embeddedEnvironmentApi.defaultEnvironmentName());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/execution/v1/{scenarioId}/{env}"})
    public String executeScenario(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="env") String env) throws IOException {
        LOGGER.debug("executeScenario for scenarioId='{}'", (Object)scenarioId);
        TestCase testCase = (TestCase)this.testCaseRepository.findExecutableById(scenarioId).orElseThrow(() -> new ScenarioNotFoundException(scenarioId));
        String userId = this.userService.currentUserId();
        DataSet dataset = this.getDataSet(testCase);
        ScenarioExecutionReport report = this.executionEngine.simpleSyncExecution(new ExecutionRequest(testCase, env, userId, dataset));
        return this.reportObjectMapper.writeValueAsString((Object)this.scenarioExecutionReportMapper.toDto(report));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}"})
    public Flux<ServerSentEvent<String>> followScenarioExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("followScenarioExecution for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        return this.createScenarioExecutionSSEFlux((Observable<ScenarioExecutionReport>)this.executionEngineAsync.followExecution(scenarioId, executionId));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/stop"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void stopExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Stop for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.stop(scenarioId, executionId);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/pause"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void pauseExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Pause for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.pause(scenarioId, executionId);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/resume"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resumeExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Resume for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.resume(scenarioId, executionId);
    }

    private Flux<ServerSentEvent<String>> createScenarioExecutionSSEFlux(Observable<ScenarioExecutionReport> scenarioExecutionReports) {
        return Flux.from((Publisher)scenarioExecutionReports.map(reportEvent -> ServerSentEvent.builder().id(String.valueOf(reportEvent.executionId)).event(reportEvent.report.isTerminated() ? "last" : "partial").data((Object)this.reportObjectMapper.writeValueAsString(reportEvent)).build()).toFlowable(BackpressureStrategy.BUFFER));
    }

    private DataSet getDataSet(TestCase testCase) {
        String defaultDatasetId = testCase.metadata().defaultDataset();
        if (!defaultDatasetId.isEmpty()) {
            return this.datasetRepository.findById(defaultDatasetId);
        }
        return DataSet.NO_DATASET;
    }

    public ObjectMapper dtoReportObjectMapper() {
        SimpleModule jdomElementModule = new SimpleModule();
        jdomElementModule.addSerializer(Element.class, (JsonSerializer)new JDomElementSerializer());
        return new ObjectMapper().addMixIn(Resource.class, MyMixInForIgnoreType.class).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).registerModule((Module)jdomElementModule).findAndRegisterModules();
    }

    static class JDomElementSerializer
    extends StdSerializer<Element> {
        private static final long serialVersionUID = 1L;

        protected JDomElementSerializer() {
            this(null);
        }

        protected JDomElementSerializer(Class<Element> t) {
            super(t);
        }

        public void serialize(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            String xmlString = new XMLOutputter(Format.getCompactFormat()).outputString(element);
            jsonGenerator.writeObject((Object)xmlString);
        }
    }
}

