/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.editionlock;

import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Predicate;

public class TestCaseEdition {
    public final TestCaseMetadata testCaseMetadata;
    public final Instant startDate;
    public final String editor;

    public TestCaseEdition(TestCaseMetadata testCaseMetadata, Instant startDate, String editor) {
        Objects.requireNonNull(testCaseMetadata);
        Objects.requireNonNull(startDate);
        Objects.requireNonNull(editor);
        this.testCaseMetadata = testCaseMetadata;
        this.startDate = startDate;
        this.editor = editor;
    }

    public static Predicate<TestCaseEdition> byId(String testCaseId) {
        return tce -> tce.testCaseMetadata.id().equals(testCaseId);
    }

    public static Predicate<TestCaseEdition> byEditor(String editor) {
        return tce -> tce.editor.equals(editor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseEdition that = (TestCaseEdition)o;
        return Objects.equals(this.testCaseMetadata, that.testCaseMetadata) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.editor, that.editor);
    }

    public int hashCode() {
        return Objects.hash(this.testCaseMetadata, this.startDate, this.editor);
    }

    public String toString() {
        return "TestCaseEdition{testCaseMetadata=" + this.testCaseMetadata + ", startDate=" + this.startDate + ", editor='" + this.editor + "'}";
    }
}

