/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.campaign.domain.CampaignExecutionRepository;
import com.chutneytesting.campaign.domain.CampaignNotFoundException;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.campaign.domain.PeriodicScheduledCampaignRepository;
import com.chutneytesting.campaign.infra.CampaignExecutionDBRepository;
import com.chutneytesting.campaign.infra.CampaignJpaRepository;
import com.chutneytesting.campaign.infra.CampaignScenarioJpaRepository;
import com.chutneytesting.campaign.infra.jpa.CampaignEntity;
import com.chutneytesting.campaign.infra.jpa.CampaignScenarioEntity;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.google.common.base.Strings;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class DatabaseCampaignRepository
implements CampaignRepository {
    private final CampaignJpaRepository campaignJpaRepository;
    private final CampaignScenarioJpaRepository campaignScenarioJpaRepository;
    private final CampaignExecutionRepository campaignExecutionRepository;
    private final PeriodicScheduledCampaignRepository periodicScheduledCampaignRepository;

    public DatabaseCampaignRepository(CampaignJpaRepository campaignJpaRepository, CampaignScenarioJpaRepository campaignScenarioJpaRepository, CampaignExecutionDBRepository campaignExecutionRepository, PeriodicScheduledCampaignRepository periodicScheduledCampaignRepository) {
        this.campaignJpaRepository = campaignJpaRepository;
        this.campaignScenarioJpaRepository = campaignScenarioJpaRepository;
        this.campaignExecutionRepository = campaignExecutionRepository;
        this.periodicScheduledCampaignRepository = periodicScheduledCampaignRepository;
    }

    @Override
    @Transactional
    public Campaign createOrUpdate(Campaign campaign) {
        if (campaign.id != null && !this.campaignExists(campaign.id)) {
            CampaignEntity campaignEntity = CampaignEntity.fromDomain(campaign, 1);
            this.campaignJpaRepository.saveWithExplicitId(campaignEntity.id(), campaignEntity.title(), campaignEntity.description());
        }
        CampaignEntity campaignJpa = (CampaignEntity)this.campaignJpaRepository.save(CampaignEntity.fromDomain(campaign, this.lastCampaignVersion(campaign.id)));
        return campaignJpa.toDomain();
    }

    private boolean campaignExists(Long id) {
        try {
            this.findById(id);
            return true;
        }
        catch (CampaignNotFoundException e) {
            return false;
        }
    }

    private Integer lastCampaignVersion(Long id) {
        return Optional.ofNullable(id).flatMap(arg_0 -> ((CampaignJpaRepository)this.campaignJpaRepository).findById(arg_0)).map(CampaignEntity::version).orElse(null);
    }

    @Override
    @Transactional
    public boolean removeById(Long id) {
        if (this.campaignJpaRepository.existsById(id)) {
            this.campaignExecutionRepository.clearAllExecutionHistory(id);
            this.campaignJpaRepository.deleteById(id);
            this.periodicScheduledCampaignRepository.removeCampaignId(id);
            return true;
        }
        return false;
    }

    @Override
    public Campaign findById(Long campaignId) throws CampaignNotFoundException {
        return this.campaignJpaRepository.findById(campaignId).map(CampaignEntity::toDomain).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    @Override
    public List<Campaign> findByName(String campaignName) {
        return this.campaignJpaRepository.findAll((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("title")), campaignName.toLowerCase())).stream().map(CampaignEntity::toDomain).toList();
    }

    @Override
    public List<String> findScenariosIds(Long campaignId) {
        return this.campaignJpaRepository.findById(campaignId).map(c -> c.campaignScenarios().stream().map(CampaignScenarioEntity::scenarioId).toList()).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    @Override
    public List<Campaign> findAll() {
        return StreamSupport.stream(this.campaignJpaRepository.findAll().spliterator(), false).map(CampaignEntity::toDomain).toList();
    }

    @Override
    public List<Campaign> findCampaignsByScenarioId(String scenarioId) {
        if (Strings.isNullOrEmpty((String)scenarioId)) {
            return Collections.emptyList();
        }
        return this.campaignScenarioJpaRepository.findAllByScenarioId(scenarioId).stream().map(CampaignScenarioEntity::campaign).map(CampaignEntity::toDomain).toList();
    }
}

