/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.api;

import com.chutneytesting.campaign.api.dto.CampaignDto;
import com.chutneytesting.campaign.api.dto.CampaignExecutionFullReportDto;
import com.chutneytesting.campaign.api.dto.CampaignExecutionReportDto;
import com.chutneytesting.campaign.api.dto.CampaignExecutionReportMapper;
import com.chutneytesting.campaign.api.dto.CampaignMapper;
import com.chutneytesting.campaign.domain.CampaignExecutionRepository;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.campaign.domain.CampaignService;
import com.chutneytesting.scenario.api.raw.dto.TestCaseIndexDto;
import com.chutneytesting.scenario.infra.TestCaseRepositoryAggregator;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/v1"})
@CrossOrigin(origins={"*"})
public class CampaignController {
    private final TestCaseRepositoryAggregator repositoryAggregator;
    private final CampaignRepository campaignRepository;
    private final CampaignExecutionRepository campaignExecutionRepository;
    private final ExecutionHistoryRepository executionHistoryRepository;
    private final CampaignService campaignService;

    public CampaignController(TestCaseRepositoryAggregator repositoryAggregator, CampaignRepository campaignRepository, CampaignExecutionRepository campaignExecutionRepository, ExecutionHistoryRepository executionHistoryRepository, CampaignService campaignService) {
        this.repositoryAggregator = repositoryAggregator;
        this.campaignRepository = campaignRepository;
        this.campaignExecutionRepository = campaignExecutionRepository;
        this.executionHistoryRepository = executionHistoryRepository;
        this.campaignService = campaignService;
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PostMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public CampaignDto saveCampaign(@RequestBody CampaignDto campaign) {
        return CampaignMapper.toDtoWithoutReport(this.campaignRepository.createOrUpdate(CampaignMapper.fromDto(campaign)));
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PutMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public CampaignDto updateCampaign(@RequestBody CampaignDto campaign) {
        return CampaignMapper.toDtoWithoutReport(this.campaignRepository.createOrUpdate(CampaignMapper.fromDto(campaign)));
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @DeleteMapping(path={"/{campaignId}"}, produces={"application/json"})
    public boolean deleteCampaign(@PathVariable(value="campaignId") Long campaignId) {
        return this.campaignRepository.removeById(campaignId);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/{campaignId}"}, produces={"application/json"})
    public CampaignDto getCampaignById(@PathVariable(value="campaignId") Long campaignId) {
        Campaign campaign = this.campaignRepository.findById(campaignId);
        List<CampaignExecution> reports = this.campaignService.findExecutionsById(campaignId);
        return CampaignMapper.toDto(campaign, reports);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/execution/{campaignExecutionId}"}, produces={"application/json"})
    public CampaignExecutionFullReportDto getCampaignExecutionReportById(@PathVariable(value="campaignExecutionId") Long campaignExecutionId) {
        CampaignExecution campaignExecution = this.campaignExecutionRepository.getCampaignExecutionById(campaignExecutionId);
        List<ExecutionHistory.Execution> executions = campaignExecution.scenarioExecutionReports().stream().map(ser -> this.executionHistoryRepository.getExecution(ser.scenarioId, ser.execution.executionId())).toList();
        return CampaignExecutionReportMapper.fullExecutionToDto(campaignExecution, executions);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/{campaignId}/scenarios"}, produces={"application/json"})
    public List<TestCaseIndexDto> getCampaignScenarios(@PathVariable(value="campaignId") Long campaignId) {
        return this.campaignRepository.findScenariosIds(campaignId).stream().map(id -> this.repositoryAggregator.findMetadataById((String)id).orElseThrow(() -> new ScenarioNotFoundException(id))).map(TestCaseIndexDto::from).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<CampaignDto> getAllCampaigns() {
        return this.campaignRepository.findAll().stream().map(CampaignMapper::toDtoWithoutReport).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/lastexecutions/{limit}"}, produces={"application/json"})
    public List<CampaignExecutionReportDto> getLastExecutions(@PathVariable(value="limit") Long limit) {
        List<CampaignExecution> lastExecutions = this.campaignExecutionRepository.getLastExecutions(limit);
        return lastExecutions.stream().map(CampaignExecutionReportMapper::toDto).sorted(Comparator.comparing(value -> ((CampaignExecutionReportDto)value).getStartDate()).reversed()).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/scenario/{scenarioId}"}, produces={"application/json"})
    public List<CampaignDto> getCampaignsByScenarioId(@PathVariable(value="scenarioId") String scenarioId) {
        return this.campaignRepository.findCampaignsByScenarioId(scenarioId).stream().map(CampaignMapper::toDtoWithoutReport).collect(Collectors.toList());
    }
}

