/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.domain.explore;

import com.chutneytesting.agent.domain.explore.UndefinedPortException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlSlicer {
    private static final String URL_REGEX = "^(?<protocol>.*)://(?<host>[^:/]*)(?<port>:\\d{1,5})?(?<path>/.*)?$";
    private static final String JDBC_ORACLE_REGEX = "(?i)^jdbc:oracle:thin:@.*(\\(HOST=(?<host>.*?)\\)|\\(PORT=(?<port>.*?)\\)(.*?)){2}.*$";
    private static final Map<String, Integer> portByProtocols = new HashMap<String, Integer>();
    private static final Pattern[] patterns;
    public final String host;
    public final int port;

    public UrlSlicer(String url) {
        Matcher urlMatcher = UrlSlicer.findMatcher(url).orElseThrow(() -> new IllegalArgumentException("Given URL does not match any known pattern: " + url));
        this.host = urlMatcher.group("host");
        this.port = Optional.ofNullable(urlMatcher.group("port")).map(s -> s.startsWith(":") ? s.substring(1) : s).map(Integer::valueOf).or(() -> Optional.ofNullable(portByProtocols.get(urlMatcher.group("protocol")))).orElseThrow(() -> new UndefinedPortException(url, urlMatcher.group("protocol")));
    }

    private static Optional<Matcher> findMatcher(String url) {
        return Arrays.stream(patterns).map(pattern -> pattern.matcher(url)).filter(Matcher::find).findFirst();
    }

    static {
        portByProtocols.put("http", 80);
        portByProtocols.put("https", 443);
        portByProtocols.put("ssh", 22);
        portByProtocols.put("amqp", 5672);
        portByProtocols.put("amqps", 5671);
        portByProtocols.put("ftp", 20);
        patterns = new Pattern[]{Pattern.compile(URL_REGEX), Pattern.compile(JDBC_ORACLE_REGEX)};
    }
}

