/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.infra;

import com.chutneytesting.admin.domain.DBVacuum;
import java.sql.Connection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DefaultDBVacuum
implements DBVacuum {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDBVacuum.class);
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final DataSourceProperties dsProperties;

    public DefaultDBVacuum(NamedParameterJdbcTemplate jdbcTemplate, DataSourceProperties dsProperties) {
        this.jdbcTemplate = jdbcTemplate;
        this.dsProperties = dsProperties;
    }

    @Override
    public DBVacuum.VacuumReport vacuum() {
        long dbBeforeSize = this.size();
        LOGGER.info("Vacuum start [{}]", (Object)dbBeforeSize);
        switch (JDBCDriver.valueFromJDBCUrl(this.dsProperties.determineUrl())) {
            case SQLITE: {
                try (Connection conn = Objects.requireNonNull(this.jdbcTemplate.getJdbcTemplate().getDataSource()).getConnection();){
                    conn.setAutoCommit(true);
                    conn.createStatement().execute("VACUUM");
                }
                catch (Exception e) {
                    LOGGER.error("Error vacuuming", (Throwable)e);
                }
                break;
            }
            case POSTGRES: 
            case H2: {
                throw new UnsupportedOperationException("Database Vacuum is only supported for SQLite database");
            }
        }
        long dbAfterSize = this.size();
        LOGGER.info("Vacuum end [{}]", (Object)dbAfterSize);
        return new DBVacuum.VacuumReport(dbBeforeSize, dbAfterSize);
    }

    @Override
    public long size() {
        switch (JDBCDriver.valueFromJDBCUrl(this.dsProperties.determineUrl())) {
            case SQLITE: {
                Map result = this.jdbcTemplate.queryForMap("select page_size * page_count from pragma_page_count(), pragma_page_size()", Collections.emptyMap());
                Object size = result.values().stream().findFirst().get();
                if (size instanceof Integer) {
                    Integer ri = (Integer)size;
                    return ri.longValue();
                }
                if (!(size instanceof Long)) break;
                Long rl = (Long)size;
                return rl;
            }
            case POSTGRES: {
                Map result = this.jdbcTemplate.queryForMap("select pg_database_size(current_database())", Collections.emptyMap());
                return (Long)result.values().stream().findFirst().get();
            }
            case H2: {
                if (this.dsProperties.determineUrl().startsWith("jdbc:h2:mem")) {
                    Map result = this.jdbcTemplate.queryForMap("select memory_used()", Collections.emptyMap());
                    Long size = (Long)result.values().stream().findFirst().get();
                    return 1024L * size;
                }
                Map result = this.jdbcTemplate.queryForMap("select setting_value from information_schema.settings where setting_name = 'info.FILE_SIZE'", Collections.emptyMap());
                return Long.parseLong(result.values().stream().findFirst().get().toString());
            }
        }
        throw new UnsupportedOperationException("Database size computation is only supported for SQLite, PostGreSQL and H2 databases");
    }

    private static enum JDBCDriver {
        SQLITE("sqlite"),
        POSTGRES("postgresql"),
        H2("h2");

        final String driverName;

        private JDBCDriver(String jdbcUrlDriverName) {
            this.driverName = jdbcUrlDriverName;
        }

        static JDBCDriver valueFromJDBCUrl(String jdbcUrl) {
            for (JDBCDriver e : JDBCDriver.values()) {
                if (!e.driverName.equals(jdbcUrl.split(":")[1])) continue;
                return e;
            }
            throw new IllegalArgumentException("Cannot find a supported driver from url " + jdbcUrl);
        }
    }
}

