/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.infra.jpa;

import com.chutneytesting.execution.domain.GwtScenarioMarshaller;
import com.chutneytesting.scenario.api.raw.mapper.GwtScenarioMapper;
import com.chutneytesting.scenario.domain.gwt.GwtTestCase;
import com.chutneytesting.scenario.infra.raw.TagListMapper;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.server.core.domain.security.User;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Version;
import java.time.Instant;
import java.util.Optional;

@Entity(name="SCENARIO")
public class ScenarioEntity {
    private static final GwtScenarioMarshaller marshaller = new GwtScenarioMapper();
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="TITLE")
    private String title;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CONTENT")
    @Basic(fetch=FetchType.LAZY)
    private String content;
    @Column(name="TAGS")
    private String tags;
    @Column(name="CREATION_DATE", updatable=false)
    private Long creationDate;
    @Column(name="ACTIVATED")
    private Boolean activated;
    @Column(name="USER_ID")
    private String userId;
    @Column(name="UPDATE_DATE")
    private Long updateDate;
    @Column(name="VERSION")
    @Version
    private Integer version;
    @Column(name="DEFAULT_DATASET_ID")
    private String defaultDataset;

    public ScenarioEntity() {
    }

    public ScenarioEntity(Long id, String title, String description, String tags, Long creationDate, Boolean activated, String userId, Long updateDate, Integer version, String defaultDataset) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.tags = tags;
        this.creationDate = creationDate;
        this.activated = activated;
        this.userId = userId;
        this.updateDate = updateDate;
        this.version = version;
        this.defaultDataset = defaultDataset;
    }

    public ScenarioEntity(Long id, String title, String description, String content, String tags, Instant creationDate, Boolean activated, String userId, Instant updateDate, Integer version, String defaultDataset) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.content = content;
        this.tags = tags;
        this.creationDate = creationDate.toEpochMilli();
        this.activated = activated;
        this.userId = userId;
        this.updateDate = updateDate.toEpochMilli();
        this.version = version;
        this.defaultDataset = defaultDataset;
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContent() {
        return this.content;
    }

    public String getTags() {
        return this.tags;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getUpdateDate() {
        return this.updateDate;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getDefaultDataset() {
        return this.defaultDataset;
    }

    public void deactivate() {
        this.activated = false;
    }

    public static ScenarioEntity fromGwtTestCase(GwtTestCase testCase) {
        return new ScenarioEntity(Long.valueOf(testCase.id()), testCase.metadata().title(), testCase.metadata().description(), Optional.ofNullable(testCase.scenario).map(marshaller::serialize).orElse(null), TagListMapper.tagsListToString(testCase.metadata().tags()), testCase.metadata().creationDate(), true, User.isAnonymous((String)testCase.metadata().author()) ? null : testCase.metadata().author(), testCase.metadata().updateDate(), testCase.metadata().version(), testCase.metadata().defaultDataset());
    }

    public GwtTestCase toGwtTestCase() {
        return GwtTestCase.builder().withMetadata(TestCaseMetadataImpl.builder().withId(String.valueOf(this.id)).withTitle(this.title).withDescription(this.description).withCreationDate(Instant.ofEpochMilli(this.creationDate)).withTags(TagListMapper.tagsStringToList(this.tags)).withAuthor(this.userId).withUpdateDate(Instant.ofEpochMilli(this.updateDate)).withVersion(this.version).withDefaultDataset(this.defaultDataset).build()).withScenario(Optional.ofNullable(this.content).map(c -> new GwtScenarioMapper().deserialize(this.title, this.description, (String)c)).orElse(null)).build();
    }

    public TestCaseMetadata toTestCaseMetadata() {
        return TestCaseMetadataImpl.builder().withId(String.valueOf(this.id)).withTitle(this.title).withDescription(this.description).withTags(TagListMapper.tagsStringToList(this.tags)).withCreationDate(Instant.ofEpochMilli(this.creationDate)).withAuthor(this.userId).withUpdateDate(Instant.ofEpochMilli(this.updateDate)).withVersion(this.version).withDefaultDataset(this.defaultDataset).build();
    }
}

