/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.domain.gwt;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Strategy {
    public static final Optional<Strategy> NONE = Optional.empty();
    public static final Strategy DEFAULT = new Strategy("", Collections.emptyMap());
    public final String type;
    public final Map<String, Object> parameters;

    public Strategy(String type, Map<String, Object> parameters) {
        this.type = Optional.ofNullable(type).orElse("");
        this.parameters = Optional.ofNullable(parameters).orElse(Collections.emptyMap());
    }

    public String toString() {
        return "Strategy{type='" + this.type + "', parameters=" + this.parameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Strategy strategy = (Strategy)o;
        return this.type.equals(strategy.type) && this.parameters.equals(strategy.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.parameters);
    }
}

