/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.domain.explore;

import com.chutneytesting.agent.domain.AgentClient;
import com.chutneytesting.agent.domain.TargetId;
import com.chutneytesting.agent.domain.configure.ConfigurationState;
import com.chutneytesting.agent.domain.configure.Explorations;
import com.chutneytesting.agent.domain.configure.LocalServerIdentifier;
import com.chutneytesting.agent.domain.configure.NetworkConfiguration;
import com.chutneytesting.agent.domain.explore.AgentId;
import com.chutneytesting.agent.domain.explore.ExploreResult;
import com.chutneytesting.agent.domain.explore.ImmutableExploreResult;
import com.chutneytesting.agent.domain.explore.UndefinedPortException;
import com.chutneytesting.agent.domain.explore.UrlSlicer;
import com.chutneytesting.agent.domain.network.NetworkDescription;
import com.chutneytesting.engine.domain.delegation.ConnectionChecker;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.environment.api.target.dto.TargetDto;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExploreAgentsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExploreAgentsService.class);
    private final Explorations explorations;
    private final AgentClient agentClient;
    private final ConnectionChecker connectionChecker;
    private final LocalServerIdentifier localServerIdentifier;

    public ExploreAgentsService(Explorations explorations, AgentClient agentClient, ConnectionChecker connectionChecker, LocalServerIdentifier localServerIdentifier) {
        this.explorations = explorations;
        this.agentClient = agentClient;
        this.connectionChecker = connectionChecker;
        this.localServerIdentifier = localServerIdentifier;
    }

    public ExploreResult explore(NetworkConfiguration networkConfiguration) {
        if (this.explorations.changeStateToIfPossible(networkConfiguration, ConfigurationState.EXPLORING)) {
            return this.exploreAndMerge(networkConfiguration);
        }
        LOGGER.debug("Received already applied configure");
        return ExploreResult.EMPTY;
    }

    public void wrapUp(NetworkDescription networkDescription) {
        if (this.explorations.changeStateToIfPossible(networkDescription.configuration(), ConfigurationState.WRAPING_UP)) {
            this.dispatch(networkDescription);
            this.explorations.changeStateToIfPossible(networkDescription.configuration(), ConfigurationState.FINISHED);
        } else {
            LOGGER.debug("Received already applied description");
        }
    }

    private ExploreResult exploreAndMerge(NetworkConfiguration networkConfiguration) {
        String localName = this.localServerIdentifier.getLocalName(networkConfiguration);
        Set<ExploreResult> exploreResults = this.exploreToRemoteAgentsAndTargets(localName, networkConfiguration);
        ExploreResult.Links<AgentId, AgentId> agentLinks = this.aggregateLinks(exploreResults, ExploreResult::agentLinks);
        ExploreResult.Links<AgentId, TargetId> targetLinks = this.aggregateLinks(exploreResults, ExploreResult::targetLinks);
        return ImmutableExploreResult.of(agentLinks, targetLinks);
    }

    private ExploreResult detectAvailableTargets(String localName, NetworkConfiguration networkConfiguration) {
        Set targetLinks = networkConfiguration.environmentConfiguration().stream().flatMap(e -> e.targets.stream().map(t -> Pair.of((Object)e.name, (Object)t)).filter(p -> {
            try {
                NamedHostAndPort namedHostAndPort = this.namedHostAndPortFromTarget((TargetDto)p.getRight());
                return this.connectionChecker.canConnectTo(namedHostAndPort);
            }
            catch (UndefinedPortException ex) {
                LOGGER.warn(ex.getMessage());
                return false;
            }
        }).map(p -> TargetId.of(((TargetDto)p.getRight()).name, (String)p.getLeft())).map(targetIdentifier -> ImmutableExploreResult.Link.of(AgentId.of(localName), targetIdentifier))).collect(Collectors.toSet());
        return ImmutableExploreResult.of(ExploreResult.Links.empty(), ImmutableExploreResult.Links.of(targetLinks));
    }

    private Set<ExploreResult> exploreToRemoteAgentsAndTargets(String localName, NetworkConfiguration networkConfiguration) {
        Set remoteExplorationResults = networkConfiguration.agentNetworkConfiguration().stream().filter(agentInfo -> !localName.equals(agentInfo.name())).map(agentInfo -> this.agentClient.explore(localName, (NamedHostAndPort)agentInfo, networkConfiguration)).collect(Collectors.toSet());
        ExploreResult localTargetsExplorationResult = this.detectAvailableTargets(localName, networkConfiguration);
        return ImmutableSet.builder().addAll(remoteExplorationResults).add((Object)localTargetsExplorationResult).build();
    }

    private <S, D> ExploreResult.Links<S, D> aggregateLinks(Set<ExploreResult> exploreResults, Function<ExploreResult, ExploreResult.Links<S, D>> linksExtractor) {
        return ImmutableExploreResult.Links.of(exploreResults.stream().map(linksExtractor).flatMap(ExploreResult.Links::stream).collect(Collectors.toSet()));
    }

    private void dispatch(NetworkDescription networkDescription) {
        String localName = this.localServerIdentifier.getLocalName(networkDescription.configuration());
        networkDescription.configuration().agentNetworkConfiguration().stream().filter(agentInfo -> !localName.equals(agentInfo.name())).forEach(agentInfo -> this.agentClient.wrapUp((NamedHostAndPort)agentInfo, networkDescription));
    }

    private NamedHostAndPort namedHostAndPortFromTarget(TargetDto target) {
        UrlSlicer urlSlicer = new UrlSlicer(target.url);
        return new NamedHostAndPort(target.name, urlSlicer.host, urlSlicer.port);
    }
}

