/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.api;

import com.chutneytesting.admin.domain.DBVacuum;
import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/database"})
@CrossOrigin(origins={"*"})
public class DatabaseManagementController {
    private final ExecutionHistoryRepository executionHistoryRepository;
    private final DBVacuum dbVacuum;

    DatabaseManagementController(ExecutionHistoryRepository executionHistoryRepository, DBVacuum dbVacuum) {
        this.executionHistoryRepository = executionHistoryRepository;
        this.dbVacuum = dbVacuum;
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={"/execution"}, produces={"application/json"})
    public List<ExecutionSummaryDto> getExecutionReportMatchQuery(@QueryParam(value="query") String query) {
        return this.executionHistoryRepository.getExecutionReportMatchQuery(query).stream().map(ExecutionSummaryDto::toDto).toList();
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(path={"/compact"}, produces={"application/json"})
    public List<Long> vacuum() {
        DBVacuum.VacuumReport report = this.dbVacuum.vacuum();
        return List.of(report.beforeSize(), report.afterSize());
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={"/size"}, produces={"application/json"})
    public Long dbSize() {
        return this.dbVacuum.size();
    }
}

