/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api.schedule;

import com.chutneytesting.server.core.domain.execution.history.PurgeService;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SchedulePurge {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulePurge.class);
    private final PurgeService purgeService;
    private final Integer timeout;
    private final Integer maxRetries;

    public SchedulePurge(PurgeService purgeService, @Value(value="${chutney.server.schedule-purge.timeout:600}") Integer timeout, @Value(value="${chutney.server.schedule-purge.retry:2}") Integer maxRetries) {
        this.purgeService = purgeService;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
    }

    @Scheduled(cron="${chutney.server.schedule-purge.cron:0 0 1 * * *}")
    public Optional<PurgeService.PurgeReport> launchPurge() {
        try {
            LOGGER.debug("Launch executions purge : START");
            Optional<PurgeService.PurgeReport> optional = Optional.of(this.retryExceptionallyAsync(() -> ((PurgeService)this.purgeService).purge(), this.maxRetries).get(this.timeout.intValue(), TimeUnit.SECONDS));
            return optional;
        }
        catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
            LOGGER.error("Purge did not finish correctly.", (Throwable)e);
        }
        finally {
            LOGGER.debug("Launch executions purge : END");
        }
        return Optional.empty();
    }

    private <T> CompletableFuture<T> retryExceptionallyAsync(Supplier<T> supplier, int maxRetries) {
        CompletionStage<T> cf = CompletableFuture.supplyAsync(supplier);
        int i = 0;
        while (i < maxRetries) {
            int finalI = i++;
            cf = cf.exceptionallyAsync(throwable -> {
                LOGGER.debug("Retry executions purge : {}", (Object)finalI);
                return supplier.get();
            });
        }
        return cf;
    }
}

