/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra.jpa;

import com.chutneytesting.campaign.infra.jpa.CampaignScenarioEntity;
import com.chutneytesting.scenario.infra.raw.TagListMapper;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Entity(name="CAMPAIGN")
public class CampaignEntity
implements Serializable {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="TITLE")
    private String title;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="ENVIRONMENT")
    private String environment;
    @Column(name="PARALLEL_RUN")
    private Boolean parallelRun;
    @Column(name="RETRY_AUTO")
    private Boolean retryAuto;
    @Column(name="DATASET_ID")
    private String datasetId;
    @Column(name="TAGS")
    private String tags;
    @Column(name="VERSION")
    @Version
    private Integer version;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="campaign")
    @OrderBy(value="rank ASC")
    private List<CampaignScenarioEntity> campaignScenarios;

    public CampaignEntity() {
    }

    public CampaignEntity(String title) {
        this(null, title, "", null, false, false, null, null, null, null);
    }

    public CampaignEntity(String title, List<CampaignScenarioEntity> scenarios) {
        this(null, title, "", null, false, false, null, null, null, scenarios);
    }

    public CampaignEntity(Long id, String title, String description, String environment, boolean parallelRun, boolean retryAuto, String datasetId, List<String> tags, Integer version, List<CampaignScenarioEntity> campaignScenarios) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.environment = environment;
        this.parallelRun = parallelRun;
        this.retryAuto = retryAuto;
        this.datasetId = datasetId;
        this.tags = TagListMapper.tagsListToString(tags);
        this.version = Optional.ofNullable(version).orElse(1);
        this.fromCampaignScenarios(campaignScenarios);
    }

    public static CampaignEntity fromDomain(Campaign campaign, Integer version) {
        return new CampaignEntity(campaign.id, campaign.title, campaign.description, campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, campaign.externalDatasetId, campaign.tags, version, CampaignScenarioEntity.fromDomain(campaign));
    }

    private void fromCampaignScenarios(List<CampaignScenarioEntity> campaignScenarioEntities) {
        this.initCampaignScenarios();
        if (campaignScenarioEntities != null && !campaignScenarioEntities.isEmpty()) {
            this.campaignScenarios.clear();
            this.campaignScenarios.addAll(campaignScenarioEntities);
            this.attachCampaignScenarios();
        }
    }

    public Campaign toDomain() {
        return new Campaign(this.id, this.title, this.description, this.campaignScenarios.stream().map(CampaignScenarioEntity::scenarioId).toList(), this.environment, this.parallelRun.booleanValue(), this.retryAuto.booleanValue(), this.datasetId, TagListMapper.tagsStringToList(this.tags));
    }

    public Long id() {
        return this.id;
    }

    public String title() {
        return this.title;
    }

    public List<CampaignScenarioEntity> campaignScenarios() {
        return this.campaignScenarios;
    }

    public Integer version() {
        return this.version;
    }

    private void initCampaignScenarios() {
        if (this.campaignScenarios == null) {
            this.campaignScenarios = new ArrayList<CampaignScenarioEntity>();
        }
    }

    private void attachCampaignScenarios() {
        Optional.ofNullable(this.campaignScenarios).ifPresent(css -> css.forEach(cs -> cs.forCampaign(this)));
    }
}

