package com.chutneytesting.design.api.plugins.linkifier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LinkifierDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLinkifierDto.builder()}.
 */
@Generated(from = "LinkifierDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLinkifierDto
    implements LinkifierDto {
  private final String pattern;
  private final String link;
  private final String id;

  private ImmutableLinkifierDto(String pattern, String link, String id) {
    this.pattern = pattern;
    this.link = link;
    this.id = id;
  }

  /**
   * @return The value of the {@code pattern} attribute
   */
  @JsonProperty("pattern")
  @Override
  public String pattern() {
    return pattern;
  }

  /**
   * @return The value of the {@code link} attribute
   */
  @JsonProperty("link")
  @Override
  public String link() {
    return link;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LinkifierDto#pattern() pattern} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pattern
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkifierDto withPattern(String value) {
    String newValue = Objects.requireNonNull(value, "pattern");
    if (this.pattern.equals(newValue)) return this;
    return new ImmutableLinkifierDto(newValue, this.link, this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LinkifierDto#link() link} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for link
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkifierDto withLink(String value) {
    String newValue = Objects.requireNonNull(value, "link");
    if (this.link.equals(newValue)) return this;
    return new ImmutableLinkifierDto(this.pattern, newValue, this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LinkifierDto#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkifierDto withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableLinkifierDto(this.pattern, this.link, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLinkifierDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLinkifierDto
        && equalTo(0, (ImmutableLinkifierDto) another);
  }

  private boolean equalTo(int synthetic, ImmutableLinkifierDto another) {
    return pattern.equals(another.pattern)
        && link.equals(another.link)
        && id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code pattern}, {@code link}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pattern.hashCode();
    h += (h << 5) + link.hashCode();
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LinkifierDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LinkifierDto{"
        + "pattern=" + pattern
        + ", link=" + link
        + ", id=" + id
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LinkifierDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LinkifierDto {
    @Nullable String pattern;
    @Nullable String link;
    @Nullable String id;
    @JsonProperty("pattern")
    public void setPattern(String pattern) {
      this.pattern = pattern;
    }
    @JsonProperty("link")
    public void setLink(String link) {
      this.link = link;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @Override
    public String pattern() { throw new UnsupportedOperationException(); }
    @Override
    public String link() { throw new UnsupportedOperationException(); }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLinkifierDto fromJson(Json json) {
    ImmutableLinkifierDto.Builder builder = ImmutableLinkifierDto.builder();
    if (json.pattern != null) {
      builder.pattern(json.pattern);
    }
    if (json.link != null) {
      builder.link(json.link);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LinkifierDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LinkifierDto instance
   */
  public static ImmutableLinkifierDto copyOf(LinkifierDto instance) {
    if (instance instanceof ImmutableLinkifierDto) {
      return (ImmutableLinkifierDto) instance;
    }
    return ImmutableLinkifierDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLinkifierDto ImmutableLinkifierDto}.
   * <pre>
   * ImmutableLinkifierDto.builder()
   *    .pattern(String) // required {@link LinkifierDto#pattern() pattern}
   *    .link(String) // required {@link LinkifierDto#link() link}
   *    .id(String) // required {@link LinkifierDto#id() id}
   *    .build();
   * </pre>
   * @return A new ImmutableLinkifierDto builder
   */
  public static ImmutableLinkifierDto.Builder builder() {
    return new ImmutableLinkifierDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLinkifierDto ImmutableLinkifierDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LinkifierDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PATTERN = 0x1L;
    private static final long INIT_BIT_LINK = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String pattern;
    private @Nullable String link;
    private @Nullable String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LinkifierDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LinkifierDto instance) {
      Objects.requireNonNull(instance, "instance");
      pattern(instance.pattern());
      link(instance.link());
      id(instance.id());
      return this;
    }

    /**
     * Initializes the value for the {@link LinkifierDto#pattern() pattern} attribute.
     * @param pattern The value for pattern 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pattern")
    public final Builder pattern(String pattern) {
      this.pattern = Objects.requireNonNull(pattern, "pattern");
      initBits &= ~INIT_BIT_PATTERN;
      return this;
    }

    /**
     * Initializes the value for the {@link LinkifierDto#link() link} attribute.
     * @param link The value for link 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("link")
    public final Builder link(String link) {
      this.link = Objects.requireNonNull(link, "link");
      initBits &= ~INIT_BIT_LINK;
      return this;
    }

    /**
     * Initializes the value for the {@link LinkifierDto#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLinkifierDto ImmutableLinkifierDto}.
     * @return An immutable instance of LinkifierDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLinkifierDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLinkifierDto(pattern, link, id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATTERN) != 0) attributes.add("pattern");
      if ((initBits & INIT_BIT_LINK) != 0) attributes.add("link");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build LinkifierDto, some of required attributes are not set " + attributes;
    }
  }
}
