/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.domain.raw;

import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import java.util.Objects;
import java.util.Optional;

public class RawTestCase
implements TestCase {
    public final TestCaseMetadataImpl metadata;
    public final String scenario;

    public RawTestCase(TestCaseMetadataImpl metadata, String scenario) {
        this.metadata = metadata;
        this.scenario = scenario;
    }

    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    public String toString() {
        return "RawTestCase{metadata=" + this.metadata + ", scenario=" + this.scenario + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawTestCase that = (RawTestCase)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.scenario, that.scenario);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.scenario);
    }

    public static RawTestCaseBuilder builder() {
        return new RawTestCaseBuilder();
    }

    public static class RawTestCaseBuilder {
        private TestCaseMetadataImpl metadata;
        private String scenario;

        private RawTestCaseBuilder() {
        }

        public RawTestCase build() {
            return new RawTestCase(Optional.ofNullable(this.metadata).orElseGet(() -> TestCaseMetadataImpl.builder().build()), Optional.ofNullable(this.scenario).orElse(""));
        }

        public RawTestCaseBuilder withMetadata(TestCaseMetadataImpl metadata) {
            this.metadata = metadata;
            return this;
        }

        public RawTestCaseBuilder withScenario(String scenario) {
            this.scenario = scenario;
            return this;
        }
    }
}

