/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain;

import com.chutneytesting.campaign.domain.CampaignExecutionRepository;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.execution.history.PurgeService;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeServiceImpl
implements PurgeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PurgeServiceImpl.class);
    private final PurgeExecutionService<Campaign, Long, CampaignExecution> campaignPurgeService;
    private final PurgeExecutionService<TestCaseMetadata, String, ExecutionHistory.ExecutionSummary> scenarioPurgeService;

    public PurgeServiceImpl(TestCaseRepository testCaseRepository, ExecutionHistoryRepository executionsRepository, CampaignRepository campaignRepository, CampaignExecutionRepository campaignExecutionRepository, Integer maxScenarioExecutionsConfiguration, Integer maxCampaignExecutionsConfiguration) {
        Integer maxScenarioExecutions = PurgeServiceImpl.validateConfigurationLimit(maxScenarioExecutionsConfiguration, "maxScenarioExecutions");
        Integer maxCampaignExecutions = PurgeServiceImpl.validateConfigurationLimit(maxCampaignExecutionsConfiguration, "maxCampaignExecutions");
        this.scenarioPurgeService = PurgeServiceImpl.buildScenarioService(testCaseRepository, executionsRepository, maxScenarioExecutions);
        this.campaignPurgeService = this.buildCampaignService(campaignRepository, campaignExecutionRepository, maxCampaignExecutions);
    }

    private static Integer validateConfigurationLimit(Integer configurationLimit, String configName) {
        if (configurationLimit <= 0) {
            LOGGER.warn("Purge configuration limit must be positive. Defaulting {} to {}", (Object)configName, (Object)10);
            return 10;
        }
        return configurationLimit;
    }

    private static PurgeExecutionService<TestCaseMetadata, String, ExecutionHistory.ExecutionSummary> buildScenarioService(TestCaseRepository testCaseRepository, ExecutionHistoryRepository executionsRepository, Integer maxScenarioExecutions) {
        return new PurgeExecutionService<TestCaseMetadata, String, ExecutionHistory.ExecutionSummary>(maxScenarioExecutions, () -> ((TestCaseRepository)testCaseRepository).findAll(), TestCaseMetadata::id, arg_0 -> ((ExecutionHistoryRepository)executionsRepository).getExecutions(arg_0), es -> es.campaignReport().isEmpty(), ExecutionHistory.Attached::executionId, ExecutionHistory.ExecutionProperties::time, ExecutionHistory.ExecutionProperties::status, ExecutionHistory.ExecutionProperties::environment, arg_0 -> ((ExecutionHistoryRepository)executionsRepository).deleteExecutions(arg_0));
    }

    private PurgeExecutionService<Campaign, Long, CampaignExecution> buildCampaignService(CampaignRepository campaignRepository, CampaignExecutionRepository campaignExecutionRepository, final Integer maxCampaignExecutions) {
        return new PurgeExecutionService<Campaign, Long, CampaignExecution>(maxCampaignExecutions.intValue(), campaignRepository::findAll, campaign -> campaign.id, campaignRepository::findExecutionsById, cer -> true, cer -> cer.executionId, cer -> cer.startDate, CampaignExecution::getStatus, cer -> cer.executionEnvironment, campaignExecutionRepository::deleteExecutions){
            private Map<Boolean, List<CampaignExecution>> campaignExecutionsByPartialExecution;

            @Override
            public List<CampaignExecution> handleExecutionsForOneEnvironment(List<CampaignExecution> executionsFromOneEnvironment) {
                this.campaignExecutionsByPartialExecution = executionsFromOneEnvironment.stream().collect(Collectors.groupingBy(cer -> cer.partialExecution));
                return this.campaignExecutionsByPartialExecution.get(false);
            }

            @Override
            public Collection<Long> findExtraExecutionsIdsToDelete(List<CampaignExecution> timeSortedExecutionsForOneEnvironment) {
                CampaignExecution oldestCampaignExecutionToKept = timeSortedExecutionsForOneEnvironment.get(maxCampaignExecutions - 1);
                return Optional.ofNullable(this.campaignExecutionsByPartialExecution.get(true)).orElse(Collections.emptyList()).stream().filter(cer -> cer.startDate.isBefore(oldestCampaignExecutionToKept.startDate)).map(cer -> cer.executionId).toList();
            }
        };
    }

    public PurgeService.PurgeReport purge() {
        Set<Long> purgedCampaignsExecutionsIds = this.campaignPurgeService.purgeExecutions();
        Set<Long> purgedScenariosExecutionsIds = this.scenarioPurgeService.purgeExecutions();
        LOGGER.info("Purge report : {} scenarios' executions deleted - {} campaigns' executions deleted", (Object)purgedScenariosExecutionsIds.size(), (Object)purgedCampaignsExecutionsIds.size());
        return new PurgeService.PurgeReport(purgedScenariosExecutionsIds, purgedCampaignsExecutionsIds);
    }

    private static class PurgeExecutionService<Base, BaseId, Execution> {
        private final int maxExecutionsToKeep;
        private final Supplier<List<Base>> baseObject;
        private final Function<Base, BaseId> idFunction;
        private final Function<BaseId, List<Execution>> executionsFunction;
        private final Predicate<Execution> executionsFilter;
        private final Function<Execution, Long> executionIdFunction;
        private final Function<Execution, LocalDateTime> executionDateFunction;
        private final Function<Execution, ServerReportStatus> statusFunction;
        private final Function<Execution, String> environmentFunction;
        private final Consumer<Set<Long>> deleteFunction;

        private PurgeExecutionService(int maxExecutionsToKeep, Supplier<List<Base>> baseObjectSupplier, Function<Base, BaseId> idFunction, Function<BaseId, List<Execution>> executionsFunction, Predicate<Execution> executionsFilter, Function<Execution, Long> executionIdFunction, Function<Execution, LocalDateTime> executionDateFunction, Function<Execution, ServerReportStatus> statusFunction, Function<Execution, String> environmentFunction, Consumer<Set<Long>> deleteFunction) {
            this.maxExecutionsToKeep = maxExecutionsToKeep;
            this.baseObject = baseObjectSupplier;
            this.idFunction = idFunction;
            this.executionsFunction = executionsFunction;
            this.executionsFilter = executionsFilter;
            this.executionIdFunction = executionIdFunction;
            this.executionDateFunction = executionDateFunction;
            this.statusFunction = statusFunction;
            this.environmentFunction = environmentFunction;
            this.deleteFunction = deleteFunction;
        }

        Set<Long> purgeExecutions() {
            HashSet<Long> deletedExecutionsIds = new HashSet<Long>();
            this.baseObject.get().stream().map(this.idFunction).map(this.executionsFunction).forEach(executionsReports -> {
                Map<String, List<Execution>> executionsByEnvironment = executionsReports.stream().filter(this.executionsFilter).collect(Collectors.groupingBy(this.environmentFunction));
                for (List<Execution> executionsOneEnvironment : executionsByEnvironment.values()) {
                    this.purgeOneBaseObjectExecutionsForOneEnvironment(executionsOneEnvironment, deletedExecutionsIds);
                }
            });
            return deletedExecutionsIds;
        }

        private void purgeOneBaseObjectExecutionsForOneEnvironment(List<Execution> executionsOneEnvironment, Set<Long> deletedExecutionsIds) {
            try {
                List<Execution> executionsToDelete = this.handleExecutionsForOneEnvironment(executionsOneEnvironment);
                Set<Long> deleteExecutionsIds = this.purgeOldestExecutionsFromOneEnvironment(executionsToDelete);
                deletedExecutionsIds.addAll(deleteExecutionsIds);
            }
            catch (Exception e) {
                LOGGER.error("Cannot purge executions {}", executionsOneEnvironment, (Object)e);
            }
        }

        private Set<Long> purgeOldestExecutionsFromOneEnvironment(List<Execution> executionsFromOneEnvironment) {
            if (executionsFromOneEnvironment.size() <= this.maxExecutionsToKeep) {
                return Collections.emptySet();
            }
            List timeSortedExecutionsForOneEnvironment = executionsFromOneEnvironment.stream().sorted(Comparator.comparing(this.executionDateFunction).reversed()).toList();
            HashSet<Long> deletedExecutionsIdsTmp = new HashSet<Long>();
            deletedExecutionsIdsTmp.addAll(this.findOldestExecutionsIdsWhileKeepingTheLastSuccess(timeSortedExecutionsForOneEnvironment));
            deletedExecutionsIdsTmp.addAll(this.findExtraExecutionsIdsToDelete(timeSortedExecutionsForOneEnvironment));
            if (!deletedExecutionsIdsTmp.isEmpty()) {
                this.deleteFunction.accept(deletedExecutionsIdsTmp);
            }
            return deletedExecutionsIdsTmp;
        }

        private Collection<Long> findOldestExecutionsIdsWhileKeepingTheLastSuccess(List<Execution> timeSortedExecutions) {
            Long youngestSuccessExecutionIdToDelete = this.youngestSuccessExecutionIdToDelete(timeSortedExecutions);
            return timeSortedExecutions.stream().skip(this.maxExecutionsToKeep).map(this.executionIdFunction).filter(id -> !youngestSuccessExecutionIdToDelete.equals(id)).collect(Collectors.toSet());
        }

        private Long youngestSuccessExecutionIdToDelete(List<Execution> timeSortedExecutions) {
            boolean isSuccessExecutionKept = timeSortedExecutions.stream().limit(this.maxExecutionsToKeep).map(this.statusFunction).anyMatch(arg_0 -> ServerReportStatus.SUCCESS.equals(arg_0));
            if (!isSuccessExecutionKept) {
                return timeSortedExecutions.stream().skip(this.maxExecutionsToKeep).filter(es -> ServerReportStatus.SUCCESS.equals((Object)this.statusFunction.apply(es))).findFirst().map(this.executionIdFunction).orElse(-1L);
            }
            return -1L;
        }

        protected List<Execution> handleExecutionsForOneEnvironment(List<Execution> executionsFromOneEnvironment) {
            return executionsFromOneEnvironment;
        }

        protected Collection<Long> findExtraExecutionsIdsToDelete(List<Execution> timeSortedExecutionsForOneEnvironment) {
            return Collections.emptySet();
        }
    }
}

