/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.dataset.domain;

import com.chutneytesting.dataset.domain.DataSetRepository;
import com.chutneytesting.scenario.domain.gwt.GwtTestCase;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.chutneytesting.server.core.domain.dataset.DataSetNotFoundException;
import com.chutneytesting.server.core.domain.scenario.AggregatedRepository;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DatasetService {
    private final DataSetRepository datasetRepository;
    private final AggregatedRepository<GwtTestCase> testCaseRepository;

    public DatasetService(DataSetRepository dataSetRepository, AggregatedRepository<GwtTestCase> testCaseRepository) {
        this.datasetRepository = dataSetRepository;
        this.testCaseRepository = testCaseRepository;
    }

    public DataSet findById(String id) {
        return this.datasetRepository.findById(id);
    }

    public List<DataSet> findAll() {
        return this.datasetRepository.findAll().stream().sorted(DataSet.datasetComparator).collect(Collectors.toList());
    }

    public DataSet save(DataSet dataset) {
        String id = this.datasetRepository.save(dataset);
        return DataSet.builder().fromDataSet(dataset).withId(id).build();
    }

    public DataSet update(Optional<String> oldId, DataSet dataset) {
        return Optional.ofNullable(dataset.id).map(id -> {
            String newId = this.datasetRepository.save(dataset);
            oldId.ifPresent(old -> {
                if (!dataset.id.equals(newId)) {
                    this.updateScenarios((String)old, newId);
                    this.datasetRepository.removeById((String)old);
                }
            });
            return DataSet.builder().fromDataSet(dataset).withId(newId).build();
        }).orElseThrow(() -> new DataSetNotFoundException(null));
    }

    private void updateScenarios(String oldId, String newId) {
        this.testCaseRepository.findAll().stream().filter(m -> oldId.equals(m.defaultDataset())).map(m -> this.testCaseRepository.findById(m.id())).forEach(o -> o.ifPresent(tc -> this.testCaseRepository.save((TestCase)GwtTestCase.builder().from((GwtTestCase)tc).withMetadata(TestCaseMetadataImpl.TestCaseMetadataBuilder.from((TestCaseMetadata)tc.metadata).withDefaultDataset(newId).build()).build())));
    }

    public void remove(String datasetName) {
        this.datasetRepository.removeById(datasetName);
    }
}

