/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.instrument.infra;

import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.instrument.ChutneyMetrics;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;

@Component
class MicrometerMetrics
implements ChutneyMetrics {
    private final MeterRegistry meterRegistry;
    private final Map<String, Map<ServerReportStatus, AtomicLong>> statusCountCache = new HashMap<String, Map<ServerReportStatus, AtomicLong>>();

    MicrometerMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void onScenarioExecutionEnded(TestCase testCase, ExecutionHistory.Execution execution) {
        String scenarioId = testCase.metadata().id();
        List tags = testCase.metadata().tags();
        ServerReportStatus status = execution.status();
        long duration = execution.duration();
        String tagsAsString = StringUtils.join((Iterable)tags, (String)"|");
        Counter scenarioExecutionCount = this.meterRegistry.counter("scenario_execution_count", Arrays.asList(Tag.of((String)"scenarioId", (String)scenarioId), Tag.of((String)"status", (String)status.name()), Tag.of((String)"tags", (String)tagsAsString)));
        scenarioExecutionCount.increment();
        Timer scenarioExecutionTimer = this.meterRegistry.timer("scenario_execution_timer", Arrays.asList(Tag.of((String)"scenarioId", (String)scenarioId), Tag.of((String)"status", (String)status.name()), Tag.of((String)"tags", (String)tagsAsString)));
        scenarioExecutionTimer.record(duration, TimeUnit.MILLISECONDS);
    }

    public void onCampaignExecutionEnded(Campaign campaign, CampaignExecution campaignExecution) {
        String campaignId = campaign.id.toString();
        Map<ServerReportStatus, Long> campaignCountByStatus = campaignExecution.scenarioExecutionReports().stream().collect(Collectors.groupingBy(s -> s.execution.status(), Collectors.counting()));
        ServerReportStatus status = campaignExecution.status();
        long campaignDuration = campaignExecution.getDuration();
        Counter campaignExecutionCount = this.meterRegistry.counter("campaign_execution_count", Arrays.asList(Tag.of((String)"campaignId", (String)campaignId), Tag.of((String)"campaignTitle", (String)campaign.title), Tag.of((String)"status", (String)status.name())));
        campaignExecutionCount.increment();
        Timer campaignExecutionTimer = this.meterRegistry.timer("campaign_execution_timer", Collections.singleton(Tag.of((String)"campaignId", (String)campaignId)));
        campaignExecutionTimer.record(campaignDuration, TimeUnit.MILLISECONDS);
        Map<ServerReportStatus, AtomicLong> cachedMetrics = this.getMetricsInCache(campaignId);
        this.updateMetrics(campaignCountByStatus, cachedMetrics);
    }

    public void onHttpError(HttpStatusCode status) {
        Counter httpErrorCount = this.meterRegistry.counter("http_error", List.of(Tag.of((String)"status", (String)String.valueOf(status.value()))));
        httpErrorCount.increment();
    }

    private void updateMetrics(Map<ServerReportStatus, Long> scenarioCountByStatus, Map<ServerReportStatus, AtomicLong> cachedMetrics) {
        cachedMetrics.forEach((key, value) -> {
            Long valueInCache = (Long)scenarioCountByStatus.get(key);
            value.set(Objects.requireNonNullElse(valueInCache, 0L));
        });
    }

    private Map<ServerReportStatus, AtomicLong> getMetricsInCache(String campaignId) {
        Map<ServerReportStatus, AtomicLong> cachedMetrics = this.statusCountCache.get(campaignId);
        if (cachedMetrics == null) {
            Map<ServerReportStatus, AtomicLong> tmp = cachedMetrics = new HashMap<ServerReportStatus, AtomicLong>();
            Arrays.asList(ServerReportStatus.values()).forEach(s -> {
                AtomicLong initialValue = new AtomicLong(0L);
                this.meterRegistry.gauge("scenario_in_campaign_gauge", Arrays.asList(Tag.of((String)"campaignId", (String)campaignId), Tag.of((String)"scenarioStatus", (String)s.name())), (Number)initialValue);
                tmp.put((ServerReportStatus)s, initialValue);
            });
            cachedMetrics.putAll(tmp);
            this.statusCountCache.put(campaignId, cachedMetrics);
        }
        return cachedMetrics;
    }
}

